/*
 * linuxrc.c - setup root ppdd filesystem
 *
 * Copyright 1998,9 Allan Latham <alatham@flexsys-group.com>
 *
 * Use permitted under terms of GNU Public Licence only.
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mount.h>
#include <linux/major.h>

#include "ppddmount.h"

int main(int argc, char **argv)
{
	int 		fd;
        char 		buff[1024];
        char 		rdev[8];
        char 		dev[17];
        unsigned char	*end, *progname;

	progname = "linuxrc";
	ppdd_intro(progname);

	fd = open("/dev/rr",O_RDONLY);
	if (fd < 0) {
		PPDDERROR(110)
                for(;;) { sleep(1);} 
	}
	if ((read(fd,dev,17)) < 1) {
		PPDDERROR(111)
                for(;;) { sleep(1);} 
	}
        close(fd);

	dev[16] = 0;
	end = memchr(dev,10,17);
	if (end) {
		*end = 0;
	}	

	printf("Real root device is %s\n\n",dev); 

	fd = open(dev,O_RDONLY);
	if (fd < 0) {
		PPDDERROR(112)
                for(;;) { sleep(1);} 
	}
	if ((read(fd,buff,1024)) != 1024) {
		PPDDERROR(113)
                for(;;) { sleep(1);} 
	}
        close(fd);

	fd = open("block0",O_WRONLY|O_TRUNC|O_CREAT,0);
	if (fd < 0) {
		PPDDERROR(114)
                for(;;) { sleep(1);} 
	}
	fchmod(fd,0);
	fchown(fd,0,0);
	if ((write(fd,buff,1024)) != 1024) {
		PPDDERROR(115)
                for(;;) { sleep(1);} 
	}
        close(fd);

        while(set_ppdd("/dev/ppdd0",dev,NULL,NULL,NULL,0,0)) { sleep(3);}

        if (mount("/proc","/proc","proc",0,NULL)) {
		PPDDERROR(116)
         	for(;;) { sleep(1);}
	} 

	fd = open("/proc/sys/kernel/real-root-dev",O_WRONLY);

	if (fd < 0) {
		PPDDERROR(117)
                for(;;) { sleep(1);} 
	}

        sprintf(rdev,"0x%02x00\n",PPDD_MAJOR);

	if ((write(fd,rdev,7)) != 7) {
		PPDDERROR(118)
                for(;;) { sleep(1);} 
	}

        close(fd);
	umount("/proc");
	exit(0);
}

