#ifndef _LINUX_PPDD_H
#define _LINUX_PPDD_H

/*
 *  include/linux/ppdd.h
 *
 *  Copyright 1997,8,9,2000 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 */

#include <linux/bf.h>

#define PP_NAME_SIZE	256
#define PP_VERSION	12
#define PPDDKEYSIZE     32
#define PPDDMKSIZE      (8 + PPDDKEYSIZE)
#define PPDDNKEYS       17
#define PPDDENCRYPT     0
#define PPDDDECRYPT     1

struct ppdd_keys {
    	Blowfish_Key		key[PPDDNKEYS];
	unsigned long		whitev[61];
};

#ifdef __KERNEL__

#include <linux/version.h>
#include <linux/kdev_t.h>

#if LINUX_VERSION_CODE >= 0x020200

#include <asm/uaccess.h>

#define PPDD_GET_INODE(a,b) a = b->f_dentry->d_inode;
#define PPDD_PUT_USER_LONG(a,b,c) a = put_user(b,(long*)c);
#define PPDD_COPY_TO_USER(a,b,c) a = copy_to_user(b,&c,sizeof(c));
#define PPDD_COPY_FROM_USER(a,b,c) a = copy_from_user(&b,c,sizeof(b));
#define PPDD_SPIN_LOCK spin_lock_irq(&io_request_lock);
#define PPDD_SPIN_UNLOCK spin_unlock_irq(&io_request_lock);

#else

#define PPDD_GET_INODE(a,b) a = b->f_inode;
#define PPDD_PUT_USER_LONG(a,b,c) \
if (!(a = verify_area(VERIFY_WRITE,(long*)c,sizeof(long)))) \
 put_fs_long(b,(long*)c);
#define PPDD_COPY_TO_USER(a,b,c) \
if (!(a = verify_area(VERIFY_WRITE,b,sizeof(c)))) \
 memcpy_tofs(b,&c,sizeof(c));
#define PPDD_COPY_FROM_USER(a,b,c) \
if (!(a = verify_area(VERIFY_READ,c,sizeof(b)))) \
 memcpy_fromfs(&b,c,sizeof(b));
#define PPDD_SPIN_LOCK 
#define PPDD_SPIN_UNLOCK

#endif


struct ppdd_device {
	int			number;
	int			refcnt;
	int			blocksize;
	int			flags;
	int			file_version;
	kdev_t			device;
	struct inode		*inode;
	struct ppdd_keys	*keys;
	char			name[PP_NAME_SIZE];
	unsigned char		md5_bkey[PPDDKEYSIZE];
};

/*
 * Ppdd flags
 */
#define PP_FLAGS_DO_BMAP	0x00000001
#define PP_FLAGS_READ_ONLY	0x00000002
#define PP_FLAGS_USER_BSIZE	0x00000004

#endif /* __KERNEL__ */

struct ppdd_ukeys {
	unsigned char	md5_bkey[PPDDKEYSIZE];
	unsigned char	encrypt_bkey[PPDDNKEYS][PPDDKEYSIZE];
	unsigned long	whitev[61];
};

struct ppdd_info {
	int			number;				/* ioctl r/o */
	unsigned long		device; 			/* ioctl r/o */
	unsigned long		inode; 				/* ioctl r/o */
	unsigned long		rdevice;			/* ioctl r/o */
	int			flags;				/* ioctl r/o */
	int			driver_version;			/* ioctl r/o */
	int			file_version;			/* ioctl r/w */
	int			blocksize;			/* ioctl r/o */
	char			name[PP_NAME_SIZE];		/* ioctl r/o */
	struct ppdd_ukeys 	keys; 				/* ioctl w/o */
/* NB the md5 key is r/w */
	char			reserved[4];
};

/*
 * IOCTL commands --- official
 */

#define PPDD_SET_FD		0x4CF0
#define PPDD_CLR_FD		0x4CF1
#define PPDD_SET_STATUS		0x4CF2
#define PPDD_GET_STATUS		0x4CF3
#define PPDD_SWAP_FILE_INODE	0x4CF4
#define PPDD_GET_MD5_KEY	0x4CF5
#define PPDD_SET_BSIZE 		0x4CF6
#define PPDD_GET_BSIZE 		0x4CF7


/* size is in units of 512 bytes
   posf is file position in mutiples of 512 bytes
*/

extern int transfer_bf(struct ppdd_keys *keys, int cmd, unsigned char *raw,
		   unsigned char *ppdd, int size, int posf);

extern void setup_bf(struct ppdd_ukeys *ukeys, struct ppdd_keys *keys); 

extern void ppdd_scramble(int, unsigned long const *, unsigned long*, 
			unsigned long, unsigned long, unsigned long);
extern void ppdd_unscramble(int, unsigned long const *, unsigned long*,
			unsigned long, unsigned long, unsigned long);

#endif
