/*
 *  bfcrypt.c
 * 
 *  Copyright 1997,8,9 by Allan Latham <alatham@flexsys-group.com>  
 *
 *  Redistribution of this file is permitted under the GNU Public License.
 *
 *  Derived in part from the works of other authors who made those works
 *  available for use under GNU Public Licence.
 * 
 */

#include <linux/ppdd.h>

#define mix(a,b,c) \
{ \
  a -= b; a -= c; a ^= (c>>13); \
  b -= c; b -= a; b ^= (a<<8); \
  c -= a; c -= b; c ^= (b>>13); \
  a -= b; a -= c; a ^= (c>>12);  \
  b -= c; b -= a; b ^= (a<<16); \
  c -= a; c -= b; c ^= (b>>5); \
  a -= b; a -= c; a ^= (c>>3);  \
  b -= c; b -= a; b ^= (a<<10); \
  c -= a; c -= b; c ^= (b>>15); \
}


void ppdd_scramble(int size, unsigned long const *in, unsigned long *out,
			unsigned long a, unsigned long b, unsigned long c)
{
    int i,j,k;

    j = size - 2;
    k = size - 1;
 
    for (i = 0; i < j; i += 3) {
        out[i]   = a += in[i];
        out[i+1] = b += in[i+1];
        out[i+2] = c += in[i+2];
        mix(a, b, c);
    }
    out[j] = b + in[j];
    out[k] = b + in[k];
}


void ppdd_unscramble(int size, unsigned long const *in, unsigned long *out,
			unsigned long a, unsigned long b, unsigned long c)
{
    int i,j,k;
    unsigned long t;

    j = size - 2;
    k = size - 1;

    for (i = 0; i < j; i += 3) {
        out[i]   = (t = in[i])   - a;  a = t;
        out[i+1] = (t = in[i+1]) - b;  b = t;
        out[i+2] = (t = in[i+2]) - c;  c = t;
        mix(a, b, c);
    }
    out[j] = in[j] - b;
    out[k] = in[k] - b;
}


static void Blowfish_Encrypt_cbc(Blowfish_Key key, unsigned char* iv,
                  unsigned char* inbuf, unsigned char* outbuf, int length)
{
    int i;
    unsigned long niv[2];
    unsigned long* pi;

    memcpy(niv, iv, 8);
    pi = (unsigned long*)inbuf;

    for (i = 0; i < length; i += 8) {
        niv[0] ^= *pi;
        pi++;
        niv[1] ^= *pi;
        pi++;
        Blowfish_Encrypt(niv,niv,key);
        memcpy(outbuf+i, niv, 8);
    }
}


static void Blowfish_Decrypt_cbc (Blowfish_Key key, unsigned char* iv,
                     unsigned char* inbuf, unsigned char* outbuf, int length)
{
    int i;
    unsigned long niv[2];
    unsigned long miv[2];
    unsigned long* pi;
    unsigned long* po;

    memcpy(niv, iv, 8);
    pi = (unsigned long*)inbuf;
    po = (unsigned long*)outbuf;

    for (i = 0; i < length; i += 8) {
        miv[0] = pi[0];
        miv[1] = pi[1];
        Blowfish_Decrypt(pi, po, key);
        po[0] ^= niv[0];
        po[1] ^= niv[1];
        niv[0] = miv[0];
        niv[1] = miv[1];
        po += 2;
        pi += 2;
    }
}

/* size is in units of 512 bytes
   posf is file position in mutiples of 512 bytes
*/

int transfer_bf(struct ppdd_keys *keys, int cmd, unsigned char *raw,
		   unsigned char *ppdd, int size, int posf)
{

    unsigned int  posk, posw, posv;
    unsigned long whitew, whitev;

    while (size > 0) {
        if (posf > 1) {
            posk = posf % 17;
            posw = posf % 61;
            posv = posf % 59;
            whitew = keys->whitev[posw];
            whitev = keys->whitev[posv];
            if (cmd == PPDDDECRYPT) {
                Blowfish_Decrypt_cbc(keys->key[posk],
                    raw+248, raw+256, ppdd+256, 256);
                Blowfish_Decrypt_cbc(keys->key[posk],
                    ppdd+504, raw, ppdd, 256);
                ppdd_unscramble(128, (unsigned long *)ppdd,
						(unsigned long *)ppdd, 
						whitew, whitev, posf);
            } else {
                ppdd_scramble(128, (unsigned long *)ppdd,
						(unsigned long *)raw,
						whitew, whitev, posf);
                Blowfish_Encrypt_cbc(keys->key[posk],
                    raw+504, raw, raw, 512);
            }
	}
        size--;
        raw += 512;
        ppdd += 512;
        posf++;
    }
    return 0;
}

void setup_bf(struct ppdd_ukeys *ukeys, struct ppdd_keys *keys)
{
	int i;

	for(i = 0; i < PPDDNKEYS; i++) {
		Blowfish_ExpandUserKey(ukeys->encrypt_bkey[i], PPDDKEYSIZE, 
							keys->key[i]);
	}
        memcpy(keys->whitev, ukeys->whitev, sizeof(keys->whitev));
}

