/*
 *  include/linux/cldd.h
 *
 *  Copyright 1999 by Allan Latham <alatham@flexsys-group.com>  
 *
 */

#ifndef _LINUX_CLDD_H
#define _LINUX_CLDD_H

#define CLDD_BMAP_SIZE	128 	/* in units of 1024 blocks */
#define CLDD_NAME_SIZE	256
#define CLDD_VERSION	2

#ifdef __KERNEL__

#include <linux/version.h>
#include <linux/kdev_t.h>

#define CLDD_GET_DEVICE(a,b) a = b & 63;
#define CLDD_GET_SLAVE(a,b) a = (b >> 6) & 1;
#define CLDD_SLAVE_FROM_MASTER(a,b) a = b + 64;
#define CLDD_MASTER_FROM_SLAVE(a,b) a = b - 64;

#if LINUX_VERSION_CODE >= 0x020200

#include <asm/uaccess.h>

#define CLDD_GET_INODE(a,b) a = b->f_dentry->d_inode;
#define CLDD_PUT_USER_LONG(a,b,c) a = put_user(b,(long*)c);
#define CLDD_COPY_TO_USER(a,b,c) a = copy_to_user(b,&c,sizeof(c));
#define CLDD_COPY_FROM_USER(a,b,c) a = copy_from_user(&b,c,sizeof(b));

#else

#define CLDD_GET_INODE(a,b) a = b->f_inode;
#define CLDD_PUT_USER_LONG(a,b,c) \
if (!(a = verify_area(VERIFY_WRITE,(long*)c,sizeof(long)))) \
 put_fs_long(b,(long*)c);
#define CLDD_COPY_TO_USER(a,b,c) \
if (!(a = verify_area(VERIFY_WRITE,b,sizeof(c)))) \
 memcpy_tofs(b,&c,sizeof(c));
#define CLDD_COPY_FROM_USER(a,b,c) \
if (!(a = verify_area(VERIFY_READ,c,sizeof(b)))) \
 memcpy_fromfs(&b,c,sizeof(b));

#endif

struct cldd_device {
	int			number;
	int			blocksize;
	int			flags;
	int			status;
	int			real_size;
	int			report_size;
	int			bmap_size;
	int			refcnt[2];
	kdev_t			rdev;
	unsigned char		*bmap;
	struct inode		*inode;
	struct timeval		mtv;
	struct timeval		stv;
	char			name[CLDD_NAME_SIZE];
};

/*
 * cldd flags
 */
#define CLDD_FLAGS_READ_ONLY	0x00000002

#endif /* __KERNEL__ */

#define CLDD_STATUS_CLOSED	0x00000000
#define CLDD_STATUS_MASTER	0x00000001
#define CLDD_STATUS_SLAVED	0x00000002
#define CLDD_STATUS_SYNCH 	0x00000004

struct cldd_info {
	int			number;				/* ioctl r/o */
	int			flags;				/* ioctl r/o */
	int			status;				/* ioctl r/o */
	int			driver_version;			/* ioctl r/o */
	int			blocksize;			/* ioctl r/o */
	int			filesize;
	unsigned long		rdevice;			/* ioctl r/o */
	unsigned long		inode; 				/* ioctl r/o */
	struct timeval		mtv;
	struct timeval		stv;
	char			name[CLDD_NAME_SIZE];
	char			reserved[4];
};

/*
 * IOCTL commands --- we will commandeer 0x4C ('L')
 */

#define CLDD_SET_MASTER		0x4C30
#define CLDD_CLR_MASTER		0x4C31
#define CLDD_SET_STATUS		0x4C32
#define CLDD_GET_STATUS		0x4C33
#define CLDD_SET_SLAVE 		0x4C34
#define CLDD_CLR_SLAVE 		0x4C35

#endif

