//---------------------------------------------------------------------------
#include <vcl.h>
#include <cpl.h>
#pragma hdrstop
#include "faxcpl.h"

USEFORM("printerlist.cpp", frmPrinterList);
USEFORM("faxcpl.cpp", frmFaxCpl);
USERC("lprfax.RC");

//---------------------------------------------------------------------------
#define CPLICON	256
#define STRING_INFO	102
#define STRING_NAME	101

#ifndef DEBUG
#pragma warn -dup
#define OutputDebugString(x)
#pragma warn +dup
#endif

HANDLE  hinst = NULL;
extern "C" {
//---------------------------------------------------------------------------
int WINAPI _export DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
  return 1;
}

//---------------------------------------------------------------------------
//DESC: Library-defined callback function that serves as the entry point for a
//      Control Panel application
//ARGS:
//  hwndCPL - handle to Control Panel window
//  uMsg    - message
//  lParam1 - first message parameter
//  lParam2 - second message parameter
//RETURN
//  The return value depends on the message.
//---------------------------------------------------------------------------
LONG CALLBACK _export CPlApplet(HWND hwndCPL,      // handle to Control Panel window
                        UINT uMsg,         // message
                        LPARAM lParam1,    // first message parameter
                        LPARAM lParam2)    // second message parameter

{
    LPCPLINFO   lpCPlInfo;
    TfrmFaxCpl *frmFaxCpl;

    OutputDebugString("In CP1Applet");
    switch (uMsg)
    {
        case CPL_INIT:      // first message, sent once
            OutputDebugString("CPL_INIT");
            hinst = GetModuleHandle("lprfax9x.cpl");
            return TRUE;

        case CPL_GETCOUNT:  // second message, sent once
            OutputDebugString("CPL_GETCOUNT");
            return 1;

        case CPL_INQUIRE: // third message, sent once per application
            OutputDebugString("CPL_INQUIRE");
            lpCPlInfo = (LPCPLINFO) lParam2;
            lpCPlInfo->lData = 0;
            lpCPlInfo->idIcon = CPLICON;
            lpCPlInfo->idName = STRING_NAME;
            lpCPlInfo->idInfo = STRING_INFO;
            break;

        case CPL_DBLCLK:    // application icon double-clicked
            OutputDebugString("CPL_DBLCLK");
            frmFaxCpl = new TfrmFaxCpl(NULL);

            frmFaxCpl->ShowModal();

            delete frmFaxCpl;
            break;

        case CPL_STOP:      // sent once per application before CPL_EXIT
            OutputDebugString("CPL_STOP");
            break;

        case CPL_EXIT:    // sent once before FreeLibrary is called
            OutputDebugString("CPL_EXIT");        
            break;

        default:
            break;
    }
    return 0;
}//CPlApplet
}//extern c
//---------------------------------------------------------------------------
