//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "faxcpl.h"
#include "registry.hpp"
#include "winspool.h"
#include "stdlib.h"
#include "printerlist.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TfrmFaxCpl *frmFaxCpl;

#define MONITOR "mGetty Fax Monitor"
//---------------------------------------------------------------------------
__fastcall TfrmFaxCpl::TfrmFaxCpl(TComponent* Owner)
  : TForm(Owner)
{

}
//---------------------------------------------------------------------------
void __fastcall TfrmFaxCpl::FormActivate(TObject *Sender)
{
  PORT_INFO_2   *pPort2,*ppPort2;
  unsigned long  i;
  unsigned long  ulNeeded;
  unsigned long  ulReturned;

  lbxPortList->Clear();

  //Find out how much memory we need
  EnumPorts(NULL, 2, NULL, 0, &ulNeeded, &ulReturned);
  if (GetLastError() != ERROR_INSUFFICIENT_BUFFER)
    return;

  pPort2 = (PORT_INFO_2 *)malloc(ulNeeded);
  if (EnumPorts(NULL, 2, (LPBYTE)pPort2, ulNeeded, &ulNeeded, &ulReturned))
  {
    ppPort2 = pPort2;
    for ( i = 0; i < ulReturned; i++)
    {
      if (AnsiString(ppPort2->pMonitorName) == MONITOR)
      {
        lbxPortList->Items->Add(ppPort2->pPortName);
      }//if
      ppPort2 ++;
    }//for
  }//if

  lbxPortList->ItemIndex = 0;
}
//---------------------------------------------------------------------------


void __fastcall TfrmFaxCpl::btnEditClick(TObject *Sender)
{
  if (lbxPortList->ItemIndex != -1)
  {
    ConfigurePort(NULL, NULL, lbxPortList->Items->Strings[lbxPortList->ItemIndex].c_str());
    FormActivate(this);
  }//if

}
//---------------------------------------------------------------------------

void __fastcall TfrmFaxCpl::btnAddClick(TObject *Sender)
{
  AddPort(NULL, WindowHandle, MONITOR);
  FormActivate(this);
}
//---------------------------------------------------------------------------

void __fastcall TfrmFaxCpl::btnDeleteClick(TObject *Sender)
{
  AnsiString Msg;
  TfrmPrinterList *frmPrinterList;

  if (lbxPortList->ItemIndex != -1)
  {
    if (!DeletePort(NULL, WindowHandle, lbxPortList->Items->Strings[lbxPortList->ItemIndex].c_str()))
    {
     if (GetLastError() == 170)
      {
        frmPrinterList = new TfrmPrinterList(this);
        frmPrinterList->lblPortName->Caption = lbxPortList->Items->Strings[lbxPortList->ItemIndex];
        frmPrinterList->ShowModal();
        delete frmPrinterList;
      }//if
      else
      {
        Msg = AnsiString("Error deleting port. Error code ") + (int)GetLastError();
        MessageBox(WindowHandle, Msg.c_str(), "Error", MB_OK+MB_ICONERROR);
      }//else
      
    }//if
    FormActivate(this);

  }//if
}
//---------------------------------------------------------------------------

