//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "shellapi.h"
#include "dialog.h"
#include "registry.hpp"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmDialog *frmDialog;
//---------------------------------------------------------------------------
__fastcall TfrmDialog::TfrmDialog(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TfrmDialog::lblStartClick(TObject *Sender)
{
  nbkWizard->PageIndex = 0;  
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblRecipientClick(TObject *Sender)
{
  nbkWizard->PageIndex = 1;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblCoverPageClick(TObject *Sender)
{
  nbkWizard->PageIndex = 2;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblSenderClick(TObject *Sender)
{
  nbkWizard->PageIndex = 4;
}
//---------------------------------------------------------------------------
void __fastcall TfrmDialog::nbkWizardPageChanged(TObject *Sender)
{
  lblStart->ParentFont = true;
  lblRecipient->ParentFont = true;
  lblCoverPage->ParentFont = true;
  lblCoverInfo->ParentFont = true;
  lblSender->ParentFont = true;
  lblProcessing->ParentFont = true;
  lblFinish->ParentFont = true;

  btnBack->Enabled = true;
  btnNext->Enabled = true;

  switch (nbkWizard->PageIndex)
  {
    case 0:
      lblStart->Font->Color = clWhite;
      btnBack->Enabled = false;
      break;

    case 1:
      lblRecipient->Font->Color = clWhite;
      break;

    case 2:
      lblCoverPage->Font->Color = clWhite;
	  break;

	case 3:
	  lblCoverInfo->Font->Color = clWhite;
	  break;

	case 4:
	  lblSender->Font->Color = clWhite;
	  break;

	case 5:
	  lblProcessing->Font->Color = clWhite;
	  break;

	case 6:
	  lblFinish->Font->Color = clWhite;
	  btnNext->Enabled = false;
	  break;

	default:
	  break;
  }//switch
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::FormActivate(TObject *Sender)
{
  Show();
  CoverPagelbx->ItemIndex = 0;
  nbkWizard->PageIndex = 0;
  Image1->Visible = false;
  Image2->Visible = false;
  Image3->Visible = false;
  Image5->Visible = false;
  Image6->Visible = false;

  nbkWizardPageChanged(this);
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::btnNextClick(TObject *Sender)
{
  if (nbkWizard->PageIndex < nbkWizard->Pages->Count-1)
  {
    nbkWizard->PageIndex = nbkWizard->PageIndex + 1;
    if (nbkWizard->PageIndex == 3 && !CoverPage->Checked)
      nbkWizard->PageIndex = nbkWizard->PageIndex + 1;    
  }//if
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::btnBackClick(TObject *Sender)
{
  if (nbkWizard->PageIndex > 0)
  {
    nbkWizard->PageIndex = nbkWizard->PageIndex - 1;
    if (nbkWizard->PageIndex == 3 && !CoverPage->Checked)
      nbkWizard->PageIndex = nbkWizard->PageIndex - 1;
  }//if
}
//---------------------------------------------------------------------------


void __fastcall TfrmDialog::edtNameChange(TObject *Sender)
{
    Image1->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::ComboBox1Change(TObject *Sender)
{
    Image2->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::edtSenderNameChange(TObject *Sender)
{
    Image3->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblProcessingClick(TObject *Sender)
{
  nbkWizard->PageIndex = 5;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::CoverPageClick(TObject *Sender)
{
  CoverPagelbx->Enabled = CoverPage->Checked;
  if (CoverPage->Checked)
    CoverPagelbx->Font->Color = clBlack;
  else
    CoverPagelbx->Font->Color = clSilver;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblCoverInfoClick(TObject *Sender)
{
  nbkWizard->PageIndex = 3;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::CoverPagelbxChange(TObject *Sender)
{
  Image2->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::edtTopicChange(TObject *Sender)
{
  Image5->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::btnFinishClick(TObject *Sender)
{
  if (FaxNo->Text == "")
  {
	ModalResult = mrNone;
	MessageBox(NULL, "The Fax number was not entered.","Fax Number Error",MB_OK+MB_ICONERROR);
	nbkWizard->PageIndex = 1;
    return;
  }//if

  if (edtUserid->Text == "")
  {
	ModalResult = mrNone;
	MessageBox(NULL, "The userid was not entered.","Userid Error",MB_OK+MB_ICONERROR);
	nbkWizard->PageIndex = 5;
    return;
  }//if

  if (cbxNotify->Checked && edtEmail->Text.Pos("@") == 0)
  {
	ModalResult = mrNone;
	MessageBox(NULL, "email address is invalid or not entered.","Email Address Error",MB_OK+MB_ICONERROR);
	nbkWizard->PageIndex = 4;
    return;
  }//if

}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::cbxPreviewClick(TObject *Sender)
{
   TRegistry     *MyRegistry;

   Image6->Visible = true;

   if (cbxPreview->Checked)
   {
	  MyRegistry = new TRegistry();
	  MyRegistry->RootKey = HKEY_CLASSES_ROOT;
	  try
	  {
		if (MyRegistry->OpenKey(".ps", false))
		{
			if (MyRegistry->ReadString("") == "")
				cbxPreview->Checked = false;
		}//if
		else
		{
		  cbxPreview->Checked = false;
		}//else
	  }//try
	  catch(...)
	  {
		cbxPreview->Checked = false;
	  }//catch
	  delete MyRegistry;

	  if (!cbxPreview->Checked)
	    MessageBox(NULL,"There is no postscript viewer installed on your system!","Warning",MB_OK+MB_ICONWARNING);
  }//if
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::lblFinishClick(TObject *Sender)
{
  nbkWizard->PageIndex = 6;    
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::edtUseridChange(TObject *Sender)
{
  Image6->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::cbxNotifyClick(TObject *Sender)
{
	   Image6->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmDialog::FormShow(TObject *Sender)
{
	SetForegroundWindow(Handle);
	CoverPagelbx->ItemIndex = 0;
	nbkWizard->PageIndex = 0;
	Image1->Visible = false;
	Image2->Visible = false;
	Image3->Visible = false;
	Image5->Visible = false;
	Image6->Visible = false;

	nbkWizardPageChanged(this);
}
//---------------------------------------------------------------------------

