//---------------------------------------------------------------------------
#ifndef commonfaxH
#define commonfaxH

#include <vcl.h>
#pragma hdrstop
#include <winsock.h>
#include <winspool.h>
#include "winsplp.h"

#ifndef DEBUG
#pragma warn -dup
#define OutputDebugString(x)
#pragma warn +dup
#elif DEBUG==1
#undef OutputDebugString
#define OutputDebugString(x) MessageBox(NULL,x,"DEBUG",MB_OK)
#endif

//---------------------------------------------------------------------------
//Printer states
#define PS_CLOSE 0
#define PS_OPEN  1
#define PS_PRINT 2
#define PS_ERROR 0xff

typedef struct
{
  SOCKET        Socket;      // Handle to the socket
  HANDLE        File;        // Handle to the temp file
  HANDLE        hPrinter;    // Handle to the opened printer
  AnsiString    Server;      // The LPD server name
  AnsiString    Printer;     // The LP printer
  AnsiString    PortName;    // The windows port name for the lpd printer
  AnsiString    Name;        // The control file name
  AnsiString    Dest;        // The dest name
  AnsiString    DestFax;        // The dest fax number    
  AnsiString    CoverPage;   // The coverpage to be used
  AnsiString    Topic;       // The Fax topicc entered  
  TStringList  *Comment;     // The Comment's enterted
  char          TempFilePath[MAX_PATH]; // The name of the temp file
  unsigned char State;       // The state of the job
  unsigned long Port;        // The lpd port
  unsigned long JobId;       // The current jobid as passed by OpenDocPort
  unsigned short usSeqNo;    // The sequence number as read from the registry
  bool          Preview;     // True if preview is on
} PortInfo;


//----------------------------------------------------------[ Sendcmd ]---
// DESC: Utility function used to send a command to the LPD server
// ARGS: Socket   - Opened Socket handle
//       pcBuffer - Pointer to the data to be send
//       usSize   - The size of the data buffer
// RETURN:
//     Return TRUE if successful  
//--------------------------------------------------------------------------
bool Sendcmd(SOCKET Socket, char *pcBuffer, int usSize);

//--------------------------------------------------------[ GetPortList ]---
// DESC: Utility function used to get a list of all the port managed by the
//       monitor
// ARGS: List   - The list in which the ports is to be returned
// RETURN:
//     Return TRUE if successful
//--------------------------------------------------------------------------
bool GetPortList(TStrings *List);

//-----------------------------------------------------[ CommonPortExist ]---
// DESC: Utility function used to find out if a port already exists.
// ARGS: pPortName - The portname in question
// RETURN:
//     Return TRUE if exists
//--------------------------------------------------------------------------
bool CommonPortExist(char * pPortName);

//-----------------------------------------------------[ CommonOpenPort ]---
// DESC: Opens the specified port
//       see DDK help on OpenPort
// ARGS:
//    pName   - Points to a port name.
//    pHandle - Points to the memory location into which to put the handle to
//              the opened port.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL CommonOpenPort(LPSTR  pName, PHANDLE pHandle);

//--------------------------------------------------[ CommonStartDocPort ]---
// DESC: Performs the tasks it takes to start a print job on the specified port.
//       see DDK help on OpenPort
// ARGS:
//   hPort        - The handle of the port to which the print job is being sent.
//   pPrinterName - Points to the zero-terminated string that is the name of the
//                  printer to which the job is being sent.
//   JobId        - Identifies the job being sent to the spooler.
//   Level        - The job level.
//   pDocInfo     - Points to the document information.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL CommonStartDocPort(HANDLE  hPort,
                                LPSTR   pPrinterName,
                                DWORD   JobId,
                                LPSTR   pDocName);

//-----------------------------------------------------[ CommonWritePort ]---
// DESC: Writes data to the printer.
//       see DDK help on WritePort
// ARGS:
//   hPort      - The handle of the port to which to write the data.
//   pBuffer    - Points to the buffer that contains the data to be written.
//   cbBuf      - The size of the buffer, in bytes, pointed to by the pBuffer parameter.
//   pcbWritten - Points to a memory location in which to put the number of bytes written
// RETURN:
//   Returns TRUE if the operation was successful.
//---------------------------------------------------------------------------
BOOL CommonWritePort(HANDLE  hPort,
                             LPBYTE  pBuffer,
                             DWORD   cbBuf,
                             LPDWORD pcbWritten);

//------------------------------------------------------[ CommonReadPort ]---
// DESC: Reads data from the printer. This function is not called as far
//       as I could see, maybe there is same special condition this is called.
//       see DDK help on ReadPort
// ARGS:
//     hPort   - Handle of the port to read.
//     pBuffer - Points to the buffer into which to read the data.
//     cbBuf   - Specifies the size, in bytes, of the buffer pointed to by the
//               pBuffer parameter.
//     pcbRead - The number of bytes read is put into the memory location
//               pointed to by this parameter.
// RETURN:
//     Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL CommonReadPort(HANDLE hPort,
                            LPBYTE pBuffer,
                            DWORD  cbBuffer,
                            LPDWORD pcbRead);

//----------------------------------------------------[ CommonEndDocPort ]---
// DESC: Performs end-of-print-job tasks on the specified port. See RFC1179 for
//       more information on how to communicate with a LPD server and see DDK
//       help on EndDocPort.
// ARGS:
//   hPort - Handle of the port the document was printed on.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL CommonEndDocPort(HANDLE  hPort);

//-----------------------------------------------------[ CommonClosePort ]---
// DESC: Closes a previously-opened port when no printers are connected to the port. 
//       see DDK help on ClosePort
// ARGS:
//   hPort  The handle of a port previously opened by a call to the
//          OpenPort function.
// RETURN:
//   Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL CommonClosePort(HANDLE hPort);

//-------------------------------------------------------[ CommonAddPort ]---
// DESC: A port management function that adds a port to the list of currently
//       supported ports in the spooler environment. 
//       see DDK help on ClosePort
// ARGS:
//    pName        - Points to a zero-terminated string that specifies the name
//                   of the server to which the port is connected. If this string
//                   is NULL, the port is local.
//    hWnd         - A handle to the parent window of the dialog box used by the
//                   AddPort function.
//    pMonitorName - Points to a zero-terminated string that specifies the monitor
//                   associated with the port.
// RETURN:
//   Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL CommonAddPort(LPSTR   pName,
                           HWND    hWnd,
                           LPSTR   pMonitorName);

//-------------------------------------------------[ CommonConfigurePort ]---
// DESC: A port management function that configures the specified port.
//       see DDK help on ConfigurePort
// ARGS:
//    pName     - Points to a zero-terminated string that names the server on
//                which the port named in the pPortName parameter exists.
//    hWnd      - Handle to the parent window of the port-configuration dialog.
//    pPortName - Points to a zero-terminated string that names the port to be
//                configured.
// RETURN:
//    Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL CommonConfigurePort(LPSTR  pName,
                                 HWND   hWnd,
                                 LPSTR  pPortName);

//----------------------------------------------------[ CommonDeletePort ]---
// DESC: A port management function that frees the port monitor of any
//       responsibility for managing the port or monitoring print jobs on the
//       port.
//       see DDK help on DeletePort
// ARGS:
//   pName     - Points to a zero-terminated string that names the machine on
//               which the port specified in the pPortName parameter exists.
//   hWnd      - Handle to the parent window of the port deletion dialog box.
//   pPortName - Points to a zero-terminated string that names the port to be
//               deleted.
// RETURN:
//    Returns TRUE if the operation is successful.
//--------------------------------------------------------------------------
BOOL CommonDeletePort(LPSTR   pName,
                              HWND    hWnd,
                              LPSTR   pPortName);
//---------------------------------------------------------------------------
//
//                             T H E  E N D
//
//---------------------------------------------------------------------------
#endif
