//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "addport.h"
#include "commonfax.h"
#include <stdio.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "cspin"
#pragma link "CSPIN"
#pragma resource "*.dfm"
TfrmAddPort *frmAddPort;
//---------------------------------------------------------------------------
__fastcall TfrmAddPort::TfrmAddPort(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmAddPort::BitBtn1Click(TObject *Sender)
{
  AnsiString PortName;

  if (SvrName != edtServerName->Text && FaxName != edtFaxName->Text)
  {
	PortName = edtServerName->Text + ":" + edtFaxName->Text;
	if (CommonPortExist(PortName.c_str()))
	{
	  MessageBox(WindowHandle,"The port already exist.","Error", MB_OK+MB_ICONERROR);
	  ModalResult = mrNone;
	}//if
  }//if
}
//---------------------------------------------------------------------------


void __fastcall TfrmAddPort::VerifyBtnClick(TObject *Sender)
{
  char            ControlFile[256];
  SOCKADDR_IN     sin;
  char            cLocalHost[128];
  short           i;
  struct hostent *pHost;
  AnsiString      Host;
  AnsiString      User;
  SOCKET		  Socket;

  Height = 336;
  Messages->Visible = true;
  Messages->Clear();
  while(1)
  {
	  //Create the socket
	  Socket = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	  sin.sin_family    = AF_INET;

	  //Get the IP Address of the local machine
	  Messages->Lines->Add("Get localhost name...");
	  memset(cLocalHost, 0 , sizeof(cLocalHost));
	  gethostname((char *)&cLocalHost, sizeof(cLocalHost));

	  Messages->Lines->Add(AnsiString("Localhost is ") + cLocalHost);
	  // See if the host is specified in "dot address" form
	  sin.sin_addr.s_addr = inet_addr(cLocalHost);
	  if (sin.sin_addr.s_addr == INADDR_NONE)
	  {
		//See if we know where this host is
		pHost = gethostbyname(cLocalHost);
		if (pHost != NULL)
		{
		  memcpy( (char *)&sin.sin_addr, pHost->h_addr, pHost->h_length);
		}//if
		else
		{
		  Messages->Lines->Add("Error: Cannot find localhost name.");
		  break;
		}//else
	  }//if

	  //Make sure we as per RFC1179 bind to a port 721 - 731
	  Messages->Lines->Add("Searching for a open port ...");
	  for (i = 721; i < 731; i ++)
	  {
		sin.sin_port = htons(i);
		if (bind(Socket, (sockaddr *)&sin, sizeof(sin)) == 0)
		{
		  break;
		}//if
	  }//for

	  if (i == 731)
	  {
		Messages->Lines->Add("Error: No open port found - Try again.");
		break;
	  }//if

	  Messages->Lines->Add(AnsiString("Open Port found at ") + i +".");
	  //Convert the IP Address of the FAX Server
	  Messages->Lines->Add("Coverting Server name to ip address ...");
	  sin.sin_addr.s_addr = inet_addr(edtServerName->Text.c_str());
	  if (sin.sin_addr.s_addr == INADDR_NONE)
	  {
		// See if the host is specified in "dot address" form
		pHost = gethostbyname(edtServerName->Text.c_str());
		if (pHost == NULL)
		{
		  Messages->Lines->Add("Error: Unknown fax server name");
		  break;
		}//if
		else
		{
		  memcpy( (char *)&sin.sin_addr, pHost->h_addr, pHost->h_length);
		}//if
	  }//if

	  // Connect to the socket to the PRINTER well-known port.
	  Messages->Lines->Add("Connecting to " + edtServerName->Text+":"+edtFaxName->Text+ "...");
	  sin.sin_family = AF_INET;
	  sin.sin_port = htons((unsigned short)Port->Value );
	  if (connect (Socket, (LPSOCKADDR) &sin, sizeof (sin)))
	  {
		Messages->Lines->Add("Error: Connection error.");
		break;
	  }//if

	  //Tell the LPD server that we want to a status - access verification
	  Messages->Lines->Add("Requesting printer status ...");
	  sprintf(ControlFile,"\2%s\n",edtFaxName->Text.c_str());
	  if (!Sendcmd(Socket, ControlFile, strlen(ControlFile)))
	  {
		Messages->Lines->Add("Error: Access denied or Fax device invalid.");
		break;
	  }//if

	  Messages->Lines->Add("Fax Server OK");
	  closesocket(Socket);
	  break;
  }//while
}

//---------------------------------------------------------------------------
void __fastcall TfrmAddPort::FormShow(TObject *Sender)
{
	SetForegroundWindow(Handle);
	SvrName = edtServerName->Text;
	FaxName = edtFaxName->Text;

	Height = 196;
	Messages->Visible = false;
	Messages->Clear();
}
//---------------------------------------------------------------------------


