//---------------------------------------------------------------------------
#ifndef CoverpgH
#define CoverpgH
//---------------------------------------------------------------------------

#define BUFSIZE 1024
class CoverPageCl
{
  private:
    char cBuffer[BUFSIZE+1];
    char *pcBuffer;
    AnsiString FToken;
    AnsiString FValue;
    bool  ValueChanged;
    bool  FirstWrite;
    bool  FReadOnly;
    void SetValue(AnsiString Value);
    TStringList *ReplStr;
    TStringList *NewStr;
    TStream     *Stream;

    void InitPS();
  protected:
    void WriteAndReplace(TStream *Output, char * pcBuffer, long Length);

  public:
    CoverPageCl(TStream *DataStream);
    virtual CoverPageCl::~CoverPageCl();

    void NextToken();
    void WriteToken(TStream *Output);

    void Replace(AnsiString OldStr, AnsiString NewString);

    long Pages();    
    long InsertCover(TStream *OutputStream);
    long InsertProcSet(TStream *OutputStream);    

    __property AnsiString Token ={read=FToken, write=FToken};
    __property AnsiString Value ={read=FValue, write=SetValue};
    __property bool ReadOnly = {read=FReadOnly, write=FReadOnly};
};//CoverPageCl

//---------------------------------------------------------------------------
//
//                             T H E  E N D
//
//---------------------------------------------------------------------------
#endif
