//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Coverpg.h"
#include <stdlib.h>
#include <string.h>

//----------------------------------------------------------[CoverPageCl]---
CoverPageCl::CoverPageCl(TStream *DataStream)
{
  Stream = DataStream;

  FirstWrite = true;
  FReadOnly = false;
  ReplStr = new TStringList();
  NewStr = new TStringList();

  InitPS();

}//TTokenStream

//---------------------------------------------------------[~CoverPageCl]---
CoverPageCl::~CoverPageCl()
{
  delete ReplStr;
  delete NewStr;
}//CoverPageCl

//---------------------------------------------------------------[InitPS]---
void CoverPageCl::InitPS()
{
  long Length;
  
  Stream->Position = 0;
  Length = min(BUFSIZE, Stream->Size);

  memset(cBuffer, 0, sizeof(cBuffer));
  Stream->ReadBuffer(cBuffer, Length);
  pcBuffer = strstr(cBuffer,"%!");
  if (pcBuffer == NULL)
  {
    throw EStreamError("Data stream is not a valid Postscript file.");
  }//if
}//InitPs

//--------------------------------------------------------------[SetValue]---
void CoverPageCl::SetValue(AnsiString Value)
{
  FValue = Value;
  ValueChanged = true;
}//SetValue

//-------------------------------------------------------------[NextToken]---
void CoverPageCl::NextToken()
{
   // Assumetions:
   // 1. cpBuffer points to the start of a token
   // 2. the caller calls WriteToken after each call to this method

   //Get the token out
   //the end of a token can either be ' ' or ':' character.
   long Length;

   Length = strpbrk(pcBuffer," \r\n") - pcBuffer;
   if (Length > 0)
   {
     FToken = AnsiString(pcBuffer).SubString(0, Length);
     pcBuffer += Length;
     ValueChanged = false;

//     if (*(pcBuffer-1) == ':' && strstr(pcBuffer, "\n%%") != NULL)
//       FValue = AnsiString(pcBuffer).SubString(0, strstr(pcBuffer, "\n%%") - pcBuffer);
//     else

     if (*(pcBuffer-1) == ':' && strpbrk(pcBuffer, "\r\n") != NULL)
       FValue = AnsiString(pcBuffer).SubString(0, strpbrk(pcBuffer, "\r\n") - pcBuffer);
     else
       FValue = "";
   }//if
   else
   {
     FToken = "";
     FValue = "";
   }//else

}//NextToken

//---------------------------------------------------------------[Replace]---
void CoverPageCl::Replace(AnsiString OldStr, AnsiString NewString)
{
  ReplStr->Add(OldStr);
  NewStr->Add(NewString);
}//Replace

//-------------------------------------------------------[WriteAndReplace]---
void CoverPageCl::WriteAndReplace(TStream *Output, char * pcBuffer, long Length)
{
  long  i;
  char *pcToken;

  if (ReplStr->Count > 0)
  {
     pcToken = strstr(pcBuffer,"(%%");
     while (pcToken != NULL && (pcToken-pcBuffer) < Length && Length > 0)
     {
       Output->WriteBuffer(pcBuffer, pcToken-pcBuffer);
       Length -= (pcToken-pcBuffer);
       pcBuffer += (pcToken-pcBuffer);

       for (i = 0; i < ReplStr->Count; i++)
       {
          if (strstr(pcBuffer, ReplStr->Strings[i].c_str()) == pcBuffer)
          {
            Output->WriteBuffer(NewStr->Strings[i].c_str(), NewStr->Strings[i].Length());
            pcBuffer += ReplStr->Strings[i].Length();
            Length -= ReplStr->Strings[i].Length();
            break;
          }//if
       }//for

       if (i == ReplStr->Count)
         pcToken = strstr(pcBuffer+1,"(%%");
       else
         pcToken = strstr(pcBuffer,"(%%");
     }//while
  }//if

  Output->WriteBuffer(pcBuffer, Length);
}//WriteAndReplace

//------------------------------------------------------------[WriteToken]---
void CoverPageCl::WriteToken(TStream *Output)
{
   long Length;
   long Pos;
   char  *pcEndChar;

   if (!FReadOnly)
   {

     if (FirstWrite)
     {
       Output->WriteBuffer(cBuffer, strstr(cBuffer, FToken.c_str()) - cBuffer);
     }//if

     Output->WriteBuffer(FToken.c_str(), FToken.Length());
   }//if

   FirstWrite = false;
   if (ValueChanged)
   {
     if (!FReadOnly)
     {
       WriteAndReplace(Output, FValue.c_str(), FValue.Length());
       pcBuffer = strstr(pcBuffer,"\n");
     }//if
   }//if

   pcEndChar = strstr(pcBuffer,"\n%%")+1;

   Length = pcEndChar - pcBuffer;
   if (Length < 0 && Stream->Position == Stream->Size)
     Length = strlen(pcBuffer);

   while(Length < 0 && Stream->Position < Stream->Size)
   {
     if (!FReadOnly)
     {
       while (strlen(pcBuffer) > 0)
       {
         Pos = strchr(pcBuffer,'\n')-pcBuffer+1;
         if (Pos < 0)
         {
           WriteAndReplace(Output, pcBuffer, strlen(pcBuffer));
           break;
         }//if
         else
         {
           WriteAndReplace(Output, pcBuffer, strchr(pcBuffer,'\n')-pcBuffer+1);
           pcBuffer = strchr(pcBuffer,'\n')+1;
         }//else
       }//while
     }//if

     memset(cBuffer, 0 , sizeof(cBuffer));
     Length = min(BUFSIZE, Stream->Size - Stream->Position);
     Stream->ReadBuffer(cBuffer, Length);

     pcBuffer = cBuffer;
     pcEndChar = strstr(pcBuffer,"\n%%")+1;
     Length = pcEndChar - pcBuffer;
   }//if

   if (Length > 0)
   {
     if (!FReadOnly)
       WriteAndReplace(Output, pcBuffer, Length);

     pcBuffer += Length;
   }//if

   if (pcEndChar-1 != NULL)
   {
     Pos = BUFSIZE - (pcEndChar - cBuffer);
     memcpy(cBuffer, pcBuffer, Pos);
     memset(cBuffer+Pos, 0, BUFSIZE-Pos);

     Length = min( (int)(BUFSIZE-Pos), Stream->Size - Stream->Position);
     Stream->ReadBuffer(cBuffer+Pos, Length);
   }//if
   else
     memset(cBuffer, 0, sizeof(cBuffer));

   pcBuffer = cBuffer;
}//WriteToken

//--------------------------------------------------------------[ Pages ]---
// DESC: This method is used get the number of pages in this post script doc
// ARGS: none
// RETURN:
//     Return number of pages.
//--------------------------------------------------------------------------
long CoverPageCl::Pages()
{
  long Position;
  long Length;
  bool FirstToken;
  bool IsReadOnly = ReadOnly;
  AnsiString MyValue;

  Length = min(BUFSIZE, Stream->Size);
  Position = Stream->Position - (pcBuffer - cBuffer) - Length;
  FirstToken = Token == "";
  InitPS();
  NextToken();

  Stream->Position = 0;

  ReadOnly = true;
  while (Token != "%%EOF" && Token != "")
  {
    MyValue = Value.SubString(Value.Pos("(atend)"), 7);
    if (Token == "%%Pages:" && MyValue != "(atend)")
    {
      Stream->Position = Position;
      memset(cBuffer, 0, sizeof(cBuffer));
      Stream->ReadBuffer(cBuffer, Length);
      ReadOnly = IsReadOnly;
      OutputDebugString("LPRFAX: Got Pages");      
      OutputDebugString(Value.c_str());
      Length = StrToInt(Value);

      pcBuffer = cBuffer;
      FToken = "";
      FValue = "";
      if (!FirstToken)
        NextToken();

      return Length;
    }//if

    WriteToken(NULL);  //Being readonly, NULL is fine
    NextToken();
  }//if

  Stream->Position = Position;
  memset(cBuffer, 0, sizeof(cBuffer));
  Stream->ReadBuffer(cBuffer, Length);
  ReadOnly = IsReadOnly;

  pcBuffer = cBuffer;
  FToken = "";
  FValue = "";

  NextToken();
  return 0;
}//Pages

//--------------------------------------------------------[ InsertCover ]---
// DESC: This method is used to insert a Coverpage into a post script doc
// ARGS: Output   - Output stream
// RETURN:
//     Return number of pages inserted.
//--------------------------------------------------------------------------
long CoverPageCl::InsertCover(TStream *OutputStream)
{
  long       lPages=0;
  AnsiString msg;
  AnsiString MyValue;

  msg = "\n\n% Inserting cover page\n\n";
  OutputStream->WriteBuffer(msg.c_str(),msg.Length());

  ReadOnly = true;
  while (Token != "%%EndSetup" && Token != "")
  {
    WriteToken(OutputStream);  //Being readonly, just advance the pointer
    NextToken();
  }//if

  ReadOnly = false;

  Token = "";
  WriteToken(OutputStream);
  NextToken();

  while (Token != "%%Pages:" && Token != "")
  {
    WriteToken(OutputStream);
    NextToken();
  }//while

  ReadOnly = true;
  while (lPages == 0 && Token != "")
  {
    MyValue = Value.SubString(Value.Pos("(atend)"), 7);
    if (Token == "%%Pages:" && MyValue != "(atend)")
      lPages = StrToInt(Value);

    WriteToken(OutputStream);
    NextToken();
  }//while

  msg = "\n\n% End Inserting cover page\n\n";
  OutputStream->WriteBuffer(msg.c_str(),msg.Length());

  return lPages;
}//InsertCover

//------------------------------------------------------[ InsertProcSet ]---
// DESC: This method is used to insert the procset part of a Coverpage into
//       a post script doc.
// ARGS: Output   - Output stream
// RETURN:
//     Return number of pages inserted.
//--------------------------------------------------------------------------
long CoverPageCl::InsertProcSet(TStream *OutputStream)
{
  long lPages=0;
  AnsiString MyValue;

  NextToken();
  ReadOnly = true;
  while (Token != "%%BeginProlog" && Token != "")
  {
    MyValue = Value.SubString(Value.Pos("(atend)"), 7);
    if (Token == "%%Pages:" && MyValue != "(atend)")
      lPages = StrToInt(Value);

    WriteToken(OutputStream);  //Being readonly, just advance the pointer
    NextToken();
  }//if

  WriteToken(OutputStream);
  NextToken();

  ReadOnly = false;
  while (Token != "%%EndProlog" && Token != "")
  {
    WriteToken(OutputStream);
    NextToken();
  }//while

  return lPages;
}//InsertProcSet

//---------------------------------------------------------------------------
//
//                             T H E  E N D
//
//---------------------------------------------------------------------------
