//---------------------------------------------------------------------------
#include <vcl.h>
#include <controls.hpp>
#pragma hdrstop

#include <stdio.h>
#include <winsock.h>
#include <winspool.h>

#include "dialog.h"
#include "addport.h"
#include "registry.hpp"

#include "fax9x.h"

//============================================================================
//The main diffrence between the Windows 9x and Windows NT is that NT monitor
//is called with all the string being passed as UNISTRING or WIDE strings where
//Windows 9x is called using null terminated strings.
//
//All the function is implemented in commonfax.c. The Windows 9x calls these
//functions as per normal, but in the case of Windows NT we first have to
//convert the Wide strings to null terminated string before calling the common
//functions.
//============================================================================

extern AnsiString   MyRegistryRoot;

TCHAR szLocalMonitor[]  = "mGetty Fax Monitor";
TCHAR szPortDesc[]      = "Fax port";
DWORD PortInfo1Strings[]={offsetof(PORT_INFO_1, pName),
                          (DWORD)-1};

DWORD PortInfo2Strings[]={offsetof(PORT_INFO_2, pPortName),
                          offsetof(PORT_INFO_2, pMonitorName),
                          offsetof(PORT_INFO_2, pDescription),
                          (DWORD)-1};


//--------------------------------------------------------[ PackStrings ]---
// DESC: Utility function used to pack strings in the correct format for the
//       EnumPorts function
// ARGS: pSource       - Source string
//       pDest         - Dest string
//       DestOffsets   - Index into source
//       pEnd          - Index to the end of the last string
// RETURN:
//       The new index to the end of last string
//--------------------------------------------------------------------------
static LPBYTE PackStrings(LPTSTR *pSource,
                          LPBYTE pDest,
                          DWORD *DestOffsets,
                          LPBYTE pEnd)
{

   while ((int)*DestOffsets != -1)
   {
      if (*pSource)
      {
        pEnd-=strlen(*pSource)*sizeof(TCHAR) + sizeof(TCHAR);
        *(LPTSTR *)(pDest+*DestOffsets)=strcpy((LPTSTR)pEnd, *pSource);
      }//if
      else
       *(LPTSTR *)(pDest+*DestOffsets)=0;

      pSource++;
      DestOffsets++;
   }//while

   return pEnd;
}//PackStrings


//---------------------------------------------------------[ AssignPort ]---
// DESC: Utility function to insert a port into the port list structure.
// ARGS:
//       pPortName - The port name to insert
//       Level     - The level of pPortInfo (passed to EnumPorts)
//       pPortInfo - The Port info struct.  (passed to EnumPorts)
//       pEnd      - Index to the end of the last string
// RETURN:
//       The new index to the end of last string
//--------------------------------------------------------------------------
static LPBYTE  AssignPort(LPSTR pPortName,
                   DWORD   Level,
                   LPBYTE  pPortInfo,
                   LPBYTE   pEnd)
{
    LPTSTR   SourceStrings[sizeof(PORT_INFO_2)/sizeof(LPTSTR)];
    LPTSTR   *pSourceStrings=SourceStrings;
    DWORD    *pOffsets;

    switch (Level)
    {
      case 1:
          pOffsets = PortInfo1Strings;
          break;

      case 2:
          pOffsets = PortInfo2Strings;
          break;

      default:
          return pEnd;
    }//switch

    switch (Level)
    {
      case 1:
          *pSourceStrings = pPortName;
          break;

      case 2:
          *pSourceStrings++=pPortName;
          *pSourceStrings++=szLocalMonitor;
          *pSourceStrings  = szPortDesc;

           ((PPORT_INFO_2)pPortInfo)->fPortType = PORT_TYPE_WRITE;

           // Reserved
           ((PPORT_INFO_2)pPortInfo)->Reserved = 0;

          break;
    }//switch

    pEnd = PackStrings(SourceStrings, pPortInfo, pOffsets, pEnd);
    return pEnd;
}//AssignPort

//------------------------------------------------------[ Win9xEnumPorts ]---
// DESC:  Builds a list of all port managed by this port monitor.
//        see DDK help on EnumPorts
// ARGS:
//       pName      - Pointer to server name
//       Level      - Specifies type of port info structure
//       pPorts     - Pointer to buffer to receive array of port info. structures
//       cbBuf      - Specifies size, in bytes, of buffer
//       pcbNeeded  - Pointer to number of bytes stored into buffer (or required buffer size)
//       pcReturned - Pointer to number of PORT_INFO_*. structures stored into buffer
// RETURN:
//    TRUE if OK else return FALSE
//--------------------------------------------------------------------------
BOOL WINAPI Win9xEnumPorts(LPSTR   pName,
                         DWORD   Level,
                         LPBYTE  pPorts,
                         DWORD   cbBuf,
                         LPDWORD pcbNeeded,
                         LPDWORD pcReturned)
{
  char        *pPortName;
  LPBYTE       pEnd;
  int          i;

  TStringList *PortList;

  PortList = new TStringList();

  if (!GetPortList(PortList))
  {
    delete PortList;
    return NULL;
  }//if


  //First calculate the size that the buffer should be.
  *pcbNeeded = 0;
  for (i = 0; i < PortList->Count; i++)
  {
    pPortName = PortList->Strings[i].c_str();
    switch (Level)
    {
      case 1:
        *pcbNeeded += sizeof(PORT_INFO_1) + (strlen(pPortName) *sizeof(TCHAR)) + sizeof(TCHAR);
        break;

      case 2:
        *pcbNeeded += sizeof(PORT_INFO_2) + (sizeof(TCHAR) *
                      (strlen(pPortName) + 1 +
                       strlen(szLocalMonitor) + 1 +
                       strlen(szPortDesc) + 1));

        break;

      default:
        SetLastError(ERROR_INVALID_LEVEL);
        OutputDebugString("LPRFAX: Invalid Level");
        delete PortList;
        return FALSE;
    }//switch
  }//for

  //Is the caller's buffer big enought?
  if (cbBuf < *pcbNeeded)
  {
    SetLastError(ERROR_INSUFFICIENT_BUFFER);
    delete PortList;
    return FALSE;
  }//if

  //Copy the ports into the buffer
  pEnd = pPorts+cbBuf;
  *pcReturned = 0;
  for (i = 0; i < PortList->Count; i++)
  {
    pEnd = AssignPort(PortList->Strings[i].c_str(), Level, pPorts, pEnd);

    if (Level == 1)
      pPorts += sizeof(PORT_INFO_1);
    else
      pPorts += sizeof(PORT_INFO_2);
    (*pcReturned)++;
  }//for

  delete PortList;
  return TRUE;
}//EnumPorts

//-------------------------------------------------------[ Win9xOpenPort ]---
// DESC: Opens the specified port
//       see DDK help on OpenPort
// ARGS:
//    pName   - Points to a port name.
//    pHandle - Points to the memory location into which to put the handle to the opened port.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL WINAPI Win9xOpenPort(LPSTR  pName, PHANDLE pHandle)
{
   return CommonOpenPort(pName, pHandle);
}//Win9xOpenPort

//---------------------------------------------------[ Win9xStartDocPort ]---
// DESC: Performs the tasks it takes to start a print job on the specified port.
//       see DDK help on StartDocPort
// ARGS:
//   hPort        - The handle of the port to which the print job is being sent.
//   pPrinterName - Points to the zero-terminated string that is the name of the
//                  printer to which the job is being sent.
//   JobId        - Identifies the job being sent to the spooler.
//   Level        - The job level.
//   pDocInfo     - Points to the document information.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL WINAPI Win9xStartDocPort(HANDLE  hPort,
                               LPSTR   pPrinterName,
                               DWORD   JobId,
                               DWORD   Level,
                               LPBYTE  pDocInfo)
{
  return CommonStartDocPort(hPort, pPrinterName, JobId, ((PDOC_INFO_1)pDocInfo)->pDocName);
}//Win9xStartDocPort

//------------------------------------------------------[ Win9xWritePort ]---
// DESC: Writes data to the printer.
//       see DDK help on WritePort
// ARGS:
//   hPort      - The handle of the port to which to write the data.
//   pBuffer    - Points to the buffer that contains the data to be written.
//   cbBuf      - The size of the buffer, in bytes, pointed to by the pBuffer parameter.
//   pcbWritten - Points to a memory location in which to put the number of bytes written
// RETURN:
//   Returns TRUE if the operation was successful.
//---------------------------------------------------------------------------
BOOL WINAPI Win9xWritePort(HANDLE  hPort,
                            LPBYTE  pBuffer,
                            DWORD   cbBuf,
                            LPDWORD pcbWritten)
{
  return CommonWritePort(hPort, pBuffer, cbBuf, pcbWritten);
}//Win9xWritePort

//-------------------------------------------------------[ Win9xReadPort ]---
// DESC: Reads data from the printer.
//       see DDK help on ReadPort
// ARGS:
//     hPort   - Handle of the port to read.
//     pBuffer - Points to the buffer into which to read the data.
//     cbBuf   - Specifies the size, in bytes, of the buffer pointed to by the
//               pBuffer parameter.
//     pcbRead - The number of bytes read is put into the memory location
//               pointed to by this parameter.
// RETURN:
//     Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL WINAPI Win9xReadPort(HANDLE hPort,
                           LPBYTE pBuffer,
                           DWORD  cbBuffer,
                           LPDWORD pcbRead)
{
  return CommonReadPort(hPort, pBuffer, cbBuffer, pcbRead);
}//Win9xReadport

//-----------------------------------------------------[ Win9xEndDocPort ]---
// DESC: Performs end-of-print-job tasks on the specified port.
//       see DDK help on EndDocPort
// ARGS:
//   hPort - Handle of the port the document was printed on.
// RETURN:
//   Returns TRUE if the operation is successful
//---------------------------------------------------------------------------
BOOL WINAPI Win9xEndDocPort(HANDLE   hPort)
{
  return CommonEndDocPort(hPort);
}//Win9xEndDocPort

//------------------------------------------------------[ Win9xClosePort ]---
// DESC: Closes a previously-opened port when no printers are connected to the port. 
//       see DDK help on ClosePort
// ARGS:
//   hPort  The handle of a port previously opened by a call to the
//          OpenPort function.
// RETURN:
//   Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL WINAPI Win9xClosePort(HANDLE hPort)
{
   return CommonClosePort(hPort);
}//Win9xClosePort

//--------------------------------------------------------[ Win9xAddPort ]---
// DESC: A port management function that adds a port to the list of currently
//       supported ports in the spooler environment.
//       see DDK help on ClosePort
// ARGS:
//    pName        - Points to a zero-terminated string that specifies the name
//                   of the server to which the port is connected. If this string
//                   is NULL, the port is local.
//    hWnd         - A handle to the parent window of the dialog box used by the
//                   AddPort function.
//    pMonitorName - Points to a zero-terminated string that specifies the monitor
//                   associated with the port.
// RETURN:
//   Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL WINAPI Win9xAddPort(LPSTR   pName,
                          HWND    hWnd,
                          LPSTR   pMonitorName)
{
  return CommonAddPort(pName, hWnd, pMonitorName);
}//Win9xAddPort

//--------------------------------------------------[ Win9xConfigurePort ]---
// DESC: A port management function that configures the specified port.
//       see DDK help on ConfigurePort
// ARGS:
//    pName     - Points to a zero-terminated string that names the server on
//                which the port named in the pPortName parameter exists.
//    hWnd      - Handle to the parent window of the port-configuration dialog.
//    pPortName - Points to a zero-terminated string that names the port to be
//                configured.
// RETURN:
//    Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL WINAPI Win9xConfigurePort(LPSTR  pName,
                                HWND   hWnd,
                                LPSTR  pPortName)
{
  return CommonConfigurePort(pName, hWnd, pPortName);
}//Win9xConfigurePort

//----------------------------------------------------[ Win9xDeletePort ]---
// DESC: A port management function that frees the port monitor of any
//       responsibility for managing the port or monitoring print jobs on the
//       port.
//       see DDK help on DeletePort
// ARGS:
//   pName     - Points to a zero-terminated string that names the machine on
//               which the port specified in the pPortName parameter exists.
//   hWnd      - Handle to the parent window of the port deletion dialog box.
//   pPortName - Points to a zero-terminated string that names the port to be
//               deleted.
// RETURN:
//    Returns TRUE if the operation is successful.
//--------------------------------------------------------------------------
BOOL WINAPI Win9xDeletePort(LPSTR   pName,
                             HWND    hWnd,
                             LPSTR   pPortName)
{
  return CommonDeletePort(pName, hWnd, pPortName);
}//Win9xDeletePort

//--------------------------------------------[ InitializePrintMonitorEx ]---
// DESC: Sets up the function pointer table that registers with the spooler all
//       the other entry points provided by your port monitor.
//       see DDK help on InitializePrintMonitorEx
// ARGS:
//   pRegisterRoot - A string which is the full registry path to a key under
//                   HKEY_LOCAL_MACHINE where the port monitor may store
//                   monitor-specific data for its own use. If the port monitor
//                   is deleted, the Windows 95 spooler will delete this registry
//                   key; the monitor does not need to do it.
//   pMonitor      - Points to a MONITOR structure in which to set the pointers.
// RETURN:
//    Returns TRUE if the operation is successful.
//---------------------------------------------------------------------------
BOOL WINAPI _export InitializeMonitorEx(LPTSTR pRegPath, LPMONITOR lpMonitor)

{
   MyRegistryRoot = pRegPath;
   lpMonitor->pfnEnumPorts     = Win9xEnumPorts;
   lpMonitor->pfnOpenPort      = Win9xOpenPort;
   lpMonitor->pfnStartDocPort  = Win9xStartDocPort;
   lpMonitor->pfnWritePort     = Win9xWritePort;
   lpMonitor->pfnReadPort      = Win9xReadPort;
   lpMonitor->pfnEndDocPort    = Win9xEndDocPort;
   lpMonitor->pfnClosePort     = Win9xClosePort;
   lpMonitor->pfnAddPort       = Win9xAddPort;
   lpMonitor->pfnConfigurePort = Win9xConfigurePort;
   lpMonitor->pfnDeletePort    = Win9xDeletePort;
   lpMonitor->pfnOpenPortEx    = NULL;
   lpMonitor->pfnGetPrinterDataFromPort = NULL;
   lpMonitor->pfnSetPortTimeOuts = NULL;

   return TRUE;
}//InitializeMonitorEx

//---------------------------------------------------------------------------
//
//                             T H E  E N D
//
//---------------------------------------------------------------------------

