/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

/**
   Used to signal that an error has occured in the lower
   workings of the CVS machinery.  They are irrecoverable (for a
   particular transaction) and should result in the closing of the
   connection.
*/
public class CVSError extends Error
{
  /** construct a new CVSError
      @param text the text of the error message
  */
  public CVSError(String text)
  {
    m_text = text;
  }

  /** Convert a CVSError to a string */
  public String toString()
  {
    return "CVS Error: " + m_text;
  }

  /** The message text. */
  private String m_text;
}
