/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.io.*;

/**
 * A generic interface to debugging spew.
 * <p>
 * To enable normal debugging info, define the property <code>cvs.debug</code><br>
 * To enable debugging info about the actual connection logic, define
 * the property <code>cvs.conn.debug</code><br>
 */
public class CVSDebug {
  /**
   * debug spew not relating to the CVSConnection logic.
   * @param spew the string to be spewed.
   */
  public static void debug(String spew) {
    if (debugging_on) {
      try {
        writer.write("CVS: " + spew + "\n");
      }
      catch (IOException e) {
        /* oh well... debug spew just isn't working then. */
        e.printStackTrace();
      }
    }
  }
  
  /**
   * debug spew not related to the CVSConnection logic.
   * @param spew the string to be spewed.
   */
  public static void connDebug(String spew) {
    if (conn_debugging_on) {
      try {
        writer.write("CVSCONN: " + spew + "\n");
      }
      catch (IOException e) {
        /* oh well... debug spew just isn't working then. */
      }
    }
  }
  
  /**
   * used to determine whether or not debugging as been turned on.
   * @return whether or not debuggins as been turned on.
   */
  public static boolean isDebuggingOn() {
    return debugging_on;
  }
  
  /**
   * used to determine whether or not connection debugging as been turned on.
   * @return whether or not debuggins as been turned on.
   */
  public static boolean isConnectionDebuggingOn() {
    return conn_debugging_on;
  }
  
  /**
   * allows the consumer to set the writer which the spew is routed to.
   * defaults to new PrintWriter(System.out);
   * @param new_writer the writer to output debug messages to.
   */
  public static void setDebugWriter(Writer new_writer) {
    writer = new_writer;
  }
  
  /**
   * get the current debug Writer. defaults to new PrintWriter(System.out)
   * @returns the current debug Writer.
   */
  public static Writer getDebugWriter() {
	return writer;
  }
  
  private static Writer writer;
  private static boolean debugging_on;
  private static boolean conn_debugging_on;
  
  static {
    debugging_on = (System.getProperty("cvs.debug") != null);
    conn_debugging_on = (System.getProperty("cvs.conn.debug") != null);
    writer = new PrintWriter(System.out);
  }
}
