/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.requests;

import com.hungry.javacvs.server.util.*;
import com.hungry.javacvs.util.*;

import java.util.*;
import java.io.*;

public class CVSCoRequest extends CVSRequestHandler {
  private void spitOutModulesFile() throws IOException {
    try {
      File modules_file = new File(m_state.getRoot() + 
                                   File.separator + 
                                   "CVSROOT" +
                                   File.separator +
                                   "modules");
      FileReader freader = new FileReader(modules_file);
      LineNumberReader reader = new LineNumberReader(freader);
      String line;
      
      while ((line = reader.readLine()) != null) {
	    if (line.length() > 0 &&
            line.charAt(0) != '#') /* XXX should we be doing this check? */ {
          m_conn.writeString("M " + line);
        }
	  }
    }
    catch (IOException e) {
	  m_conn.writeString("E [jcvsserver] *** exception " + 
                         e.toString() + " while reading modules file.\n");
	  throw e;
	}
  }
  
  public void handleRequest() throws IOException {
    Enumeration args = m_state.argumentEnumeration();
    String arg;
    while (args.hasMoreElements()
           && (arg = (String)args.nextElement()) != null) {
	  /* if we find a -c argument, spit out the modules file and quit. */
	  if (arg.equals("-c")) {
        spitOutModulesFile();
        m_conn.writeString("\nok\n");
        m_conn.close();
        return;
      }
	}
    
    m_conn.writeString
      ("E [jcvsserver] *** Checkouts don't yet work on this server.\n");
    m_conn.writeString("ok\n");
  }
}
