/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.util;

public class CVSMode
{
  public CVSMode(int mode)
    {
      m_mode = mode;
    }

  public String toString()
    {
      String str = "";
      boolean need_comma = false;

      if ((m_mode & (OWNER_R | OWNER_W | OWNER_X)) != 0)
	{
	  str += "u=";

	  if ((m_mode & OWNER_R) != 0)
	    str += "r";
	  if ((m_mode & OWNER_W) != 0)
	    str += "w";
	  if ((m_mode & OWNER_X) != 0)
	    str += "x";

	  need_comma = true;
	}

      if ((m_mode & (GROUP_R | GROUP_W | GROUP_X)) != 0)
	{
	  if (need_comma)
	    str += ",";

	  str += "g=";

	  if ((m_mode & GROUP_R) != 0)
	    str += "r";
	  if ((m_mode & GROUP_W) != 0)
	    str += "w";
	  if ((m_mode & GROUP_X) != 0)
	    str += "x";

	  need_comma = true;
	}

      if ((m_mode & (OTHER_R | OTHER_W | OTHER_X)) != 0)
	{
	  if (need_comma)
	    str += ",";

	  str += "o=";

	  if ((m_mode & OTHER_R) != 0)
	    str += "r";
	  if ((m_mode & OTHER_W) != 0)
	    str += "w";
	  if ((m_mode & OTHER_X) != 0)
	    str += "x";
	}

      /* do some stuff. */
      return str;
    }

  public static final int OWNER_R = 0400;
  public static final int OWNER_W = 0200;
  public static final int OWNER_X = 0100;
  public static final int GROUP_R = 0040;
  public static final int GROUP_W = 0020;
  public static final int GROUP_X = 0010;
  public static final int OTHER_R = 0004;
  public static final int OTHER_W = 0002;
  public static final int OTHER_X = 0001;

  int m_mode;
}
