/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.util;

import com.hungry.javacvs.util.*;

import java.util.*;
import java.io.*;

public class CVSIgnore implements FilenameFilter
{
  private String[] default_ignores = {
    "RCS", "SCCS", "CVS", "CVS.adm", "RCSLOG", "cvslog.*",
    "tags", "TAGS", ".make.state", ".nse_depinfo",
    "*~", "#*", ".#*", ".*", "_$*", "*$", "*.old",
    "*.bak", "*.BAK", "*.orig", "*.rej", "*.del-*",
    "*.a", "*.olb", "*.o", "*.obj", "*.so", "*.exe",
    "*.Z", "*.elc", "*.ln", "core"
  };

  public CVSIgnore()
    {
      int i;
      m_vector = new Vector();
      for (i = 0; i < default_ignores.length; i ++)
	m_vector.addElement(default_ignores[i]);
    }

  public void readFromFile(File cvsrc)
    {
      try {
	FileReader reader = new FileReader(cvsrc);
	LineNumberReader lreader = new LineNumberReader(reader);
	String s;
	
	while ((s = lreader.readLine()) != null)
	  m_vector.addElement(s.trim());
      }
      catch (Exception e) {
	CVSDebug.debug ("Error while reading the .cvsignore file.");
      }
    }
  
  private boolean match(String filename,
			String pattern)
    {
      int index;
      
      if (pattern.startsWith("*"))
	{
	  String sub = pattern.substring(1);

	  return filename.endsWith(sub);
	}
      else if (pattern.endsWith("*"))
	{
	  String sub = pattern.substring(0, pattern.length() - 1);

	  return filename.startsWith(sub);
	}
      else if ((index = pattern.indexOf("*")) != -1)
	{
	  return false;
	}
      else
	return pattern.equals(filename);
    }

  public boolean accept(File directory /* unused */,
			String filename)
    {
      Enumeration enumeration = m_vector.elements();
      String pattern;

      while (enumeration.hasMoreElements()
	     && (pattern = (String)enumeration.nextElement()) != null)
	{
	  /* if the filename matches a pattern, we want
	     to not include it in the list. */
	  if (match(filename, pattern))
	    return false;
	}
      
      return true;
    }
  
  private Vector m_vector;
}
