/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.util;

import com.hungry.javacvs.util.*;

import java.security.*;
import java.net.*;
import java.io.*;

public class CVSClientJServerConnection extends CVSClientConnection
{
  public CVSClientJServerConnection(CVSRoot root)
    {
      super(root);
    }
  
  public void connect() throws IOException, UnknownHostException
    {
      InetAddress addr = InetAddress.getByName(m_root.getServer());

      attachToSocket(new Socket(addr, CVS_JSERVER_PORT));

      super.connect();
    }

  public Signer getSigner()
    {
      if (signer != null)
	{
	  return signer;
	}
      else
	{
	  IdentityScope system_scope = IdentityScope.getSystemScope();
	  Identity user;
	  PublicKey key;
	  Certificate cert = new sun.security.x509.X509Cert();
	  FileInputStream stream;
	  
	  try {
	    stream = new FileInputStream(System.getProperty("user.home") +
					 File.separator +
					 "jcvscert.509");
	    cert.decode(stream);
	    
	    stream.close();
	  }
	  catch (IOException e)
	    {
	      System.err.println("Problem reading the cvscert.509 file: " + e.toString());
	      return null;
	    }
	  catch (KeyException e)
	    {
	      System.err.println("Problem reading the cvscert.509 file: " + e.toString());
	      return null;
	    }
	  
	  user = system_scope.getIdentity(cert.getPublicKey());
	  
	  if (user instanceof Signer)
	    {
	      CVSDebug.debug(user + " is a signer.");
	      return (Signer)user;
	    }
	  else
	    {
	      CVSDebug.debug(user + " is not a signer.");
	      return null;
	    }
	}
    }

  public void authenticate(String pass)
    throws CVSAuthenticationError, IOException
    {
      try {
	String response;
	
	writeString(BEGIN_DSA_AUTH_REQUEST);
      
	writeString(m_root.getRootDir() + "\n");
	writeString(m_root.getLogin() + "\n");
      
	writeString(END_DSA_AUTH_REQUEST);
      
	response = readLine();
      
	if (!response.equals(AUTH_PARTIAL_ACK))
	  {
	    throw (new CVSAuthenticationError(response));
	  }

	/* following is 4k of random bytes. read it in, general a signature for
	   it, and send back the signature. */
	byte buf[];
	Signer signer = getSigner();
	Signature signalg = Signature.getInstance("DSA");
	byte signature[];
	int buf_length = new Integer(readLine().trim()).intValue();

	buf = new byte[buf_length];
	readBytes(buf);

	signalg.initSign(signer.getPrivateKey());
	signalg.update(buf);
	signature = signalg.sign();

	writeString(signature.length + "\n");
	writeBytes(signature);

	response = readLine();
      
	if (!response.equals(AUTH_ACK))
	  {
	    throw (new CVSAuthenticationError(response));
	  }

	CVSDebug.connDebug("Authenticated.");
      }
      catch (NoSuchAlgorithmException e)
	{
	  throw (new CVSAuthenticationError(e.toString()));
	}
      catch (SignatureException e)
	{
	  throw (new CVSAuthenticationError(e.toString()));
	}
      catch (InvalidKeyException e)
	{
	  throw (new CVSAuthenticationError(e.toString()));
	}
    }

  private static Signer signer;
}
