/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.text;

import com.hungry.javacvs.util.*;
import com.hungry.javacvs.client.*;
import com.hungry.javacvs.client.requests.*;
import com.hungry.javacvs.client.ui.*;
import com.hungry.javacvs.client.util.*;

import java.util.*;
import java.io.*;

public class CVSText extends CVSUI {
  class UIListener implements CVSUIListener {
    public void uiChanged(CVSUIEvent e) {
      if (e instanceof CVSUIStatusEvent) {
	    /* do nothing - we don't print out status messages to the console. */
	    if (CVSDebug.isDebuggingOn()) {
          CVSUIStatusEvent se = (CVSUIStatusEvent)e;
          
          CVSDebug.debug(se.getStatus());
        }
	  }
      else if (e instanceof CVSUIPasswordEvent) {
	    /* drop out, telling them to run 'jcvs login'. */
	  }
      else if (e instanceof CVSUIRequestErrorEvent) {
        CVSUIRequestErrorEvent re = (CVSUIRequestErrorEvent)e;
        System.err.println(re.getErrorMessage());
        if (CVSDebug.isDebuggingOn())
          CVSDebug.debug("client exit, status 1");
        else
          System.exit(1); /* XXX this shouldn't happen for E responses... only for error. */
      }
      else if (e instanceof CVSUIMessageEvent) {
	    CVSUIMessageEvent me = (CVSUIMessageEvent)e;
        
	    System.out.print(me.getMessage()); /* the message ends in a \n */
	  }
      else if (e instanceof CVSUIBusyStateEvent) {
	    CVSUIBusyStateEvent be = (CVSUIBusyStateEvent)e;
	    if (be.getBusyState() == false) {
          if (getConnectionClosed())
            if (CVSDebug.isDebuggingOn())
              CVSDebug.debug("client exit, status 0");
            else 
              System.exit(0);
        }
	  }
      else if (e instanceof CVSUIConnectionClosedEvent) {
	    setConnectionClosed(true);
	  }
    }
  }
  
  public CVSText() {
    String root;
    
    /*
      CVSLogWindow log_window = new CVSLogWindow();
      CVSDebug.setDebugWriter(log_window.getWriter());
    */
    
    root = System.getProperty("cvs.root");
    
    if (root != null)
      m_client.setRoot(root);
    
    // register our handlers
    addCVSUIListener(new UIListener());
  }
  
  private void outputUsage() {
    System.out.print(
      "Usage: jcvs [cvs-options] command [command-options] [files...]\n" + 
      "    Where 'cvs-options' are:\n" + 
      "        -H           Displays Usage information for command\n" + 
      "        -Q           Cause CVS to be really quiet.\n" + 
      "        -q           Cause CVS to be somewhat quiet.\n" + 
      "        -r           Make checked-out files read-only.\n" + 
      "        -w           Make checked-out files read-write.\n" + 
      "        -l           Turn history logging off.\n" + 
      "        -n           Do not execute anything that will change the disk.\n" + 
      "        -t           Show trace of program execution -- Try with -n.\n" + 
      "        -v           CVS version and copyright.\n" + 
      "        -b bindir    Find RCS programs in 'bindir'.\n" + 
      "        -e editor    Use 'editor' for editing log information.\n" + 
      "        -d CVS_root  Overrides cvs.root as the root of the CVS tree.\n" + 
      "        -f           Do not use the ~/.cvsrc file.\n" + 
      "        -z #         Use 'gzip -#' for net traffic if possible.\n" + 
      "        -s VAR=VAL   Set CVS user variable.\n" + 
      "\n" + 
      "    and where 'command' is: add, admin, etc. (use the --help-commands\n" + 
      "    option for a list of commands.)\n");
    }

  private void outputVersion() {
    System.out.print("Java Concurrent Version System (JCVS) 1.0 (client/server)\n" +
                     "\n" +
                     "Copyright (c) 1997-1998 The Hungry Programmers\n");
    }

  private void outputCommandList() {
    System.out.print(
   "CVS commands are:\n" + 
   "        add          Adds a new file/directory to the repository.\n" + 
   "        admin        Administration front end for rcs.\n" + 
   "        annotate     Show revision where each line was modified.\n" + 
   "        checkout     Checkout sources for editing.\n" + 
   "        commit       Checks files into the repository.\n" + 
   "        diff         Runs diffs between revisions.\n" + 
   "        edit         Get ready to edit a watched file.\n" + 
   "        editors      See who is editing a watched file.\n" + 
   "        history      Shows status of files and users.\n" + 
   "        import       Import sources into CVS, using vendor branches.\n" + 
   "        export       Export sources from CVS, similar to checkout.\n" + 
   "        init         Initialize a new CVS repository.\n" + 
   "        log          Prints out 'rlog' information for files.\n" + 
   "        login        Prompt for password for authenticating server.\n" + 
   "        rdiff        'patch' format diffs between releases.\n" + 
   "        release      Indicate that a Module is no longer in use.\n" + 
   "        remove       Removes an entry from the repository.\n" + 
   "        status       Status info on the revisions.\n" + 
   "        tag          Add a symbolic tag to checked out version of RCS file.\n" + 
   "        unedit       Undo an edit command.\n" + 
   "        rtag         Add a symbolic tag to the RCS file.\n" + 
   "        update       Brings work tree in sync with repository.\n" + 
   "        watch        Set watches.\n" + 
   "        watchers     See who is watching a file.\n");
  }

  public void initCommandDictionary() {
    m_commandDictionary = new Hashtable();
    
    try {
      m_commandDictionary.put("ad", new Integer(CMD_ADD));	
      m_commandDictionary.put("add", new Integer(CMD_ADD));
      m_commandDictionary.put("adm", new Integer(CMD_ADMIN));
      m_commandDictionary.put("admin", new Integer(CMD_ADMIN));
      m_commandDictionary.put("ann", new Integer(CMD_ANNOTATE));
      m_commandDictionary.put("annotate", new Integer(CMD_ANNOTATE));
      m_commandDictionary.put("co", new Integer(CMD_CHECKOUT));
      m_commandDictionary.put("checkout", new Integer(CMD_CHECKOUT));
      m_commandDictionary.put("com", new Integer(CMD_COMMIT));
      m_commandDictionary.put("commit", new Integer(CMD_COMMIT));
      m_commandDictionary.put("di", new Integer(CMD_DIFF));
      m_commandDictionary.put("dif", new Integer(CMD_DIFF));
      m_commandDictionary.put("diff", new Integer(CMD_DIFF));
      m_commandDictionary.put("edit", new Integer(CMD_EDIT));
      m_commandDictionary.put("editors", new Integer(CMD_EDITORS));
      m_commandDictionary.put("hi", new Integer(CMD_HISTORY));
      m_commandDictionary.put("his", new Integer(CMD_HISTORY));
      m_commandDictionary.put("history", new Integer(CMD_HISTORY));
      m_commandDictionary.put("im", new Integer(CMD_IMPORT));
      m_commandDictionary.put("imp", new Integer(CMD_IMPORT));
      m_commandDictionary.put("import", new Integer(CMD_IMPORT));
      m_commandDictionary.put("ex", new Integer(CMD_EXPORT));
      m_commandDictionary.put("exp", new Integer(CMD_EXPORT));
      m_commandDictionary.put("export", new Integer(CMD_EXPORT));
      m_commandDictionary.put("init", new Integer(CMD_INIT));
      m_commandDictionary.put("lo", new Integer(CMD_LOG));
      m_commandDictionary.put("log", new Integer(CMD_LOG));
      m_commandDictionary.put("login", new Integer(CMD_LOGIN));
      m_commandDictionary.put("rdiff", new Integer(CMD_RDIFF));
      m_commandDictionary.put("rel", new Integer(CMD_RELEASE));
      m_commandDictionary.put("release", new Integer(CMD_RELEASE));
      m_commandDictionary.put("rm", new Integer(CMD_REMOVE));
      m_commandDictionary.put("remove", new Integer(CMD_REMOVE));
      m_commandDictionary.put("stat", new Integer(CMD_STATUS));
      m_commandDictionary.put("status", new Integer(CMD_STATUS));
      m_commandDictionary.put("ta", new Integer(CMD_TAG));
      m_commandDictionary.put("tag", new Integer(CMD_TAG));
      m_commandDictionary.put("unedit", new Integer(CMD_UNEDIT));
      m_commandDictionary.put("rt", new Integer(CMD_RTAG));
      m_commandDictionary.put("rtag", new Integer(CMD_RTAG));
      m_commandDictionary.put("up", new Integer(CMD_UPDATE));
      m_commandDictionary.put("update", new Integer(CMD_UPDATE));
      m_commandDictionary.put("watch", new Integer(CMD_WATCH));
      m_commandDictionary.put("watchers", new Integer(CMD_WATCHERS));
    }
    catch (Exception e) {
      System.err.println("Error while initializing command dictionary: " + e);
	  System.exit(2);
	}
  }
  
  public void handleCommandLine(String args[]) {
    int cvs_command = -1;
    Vector parameters_before_command = new Vector();
    Vector parameters_after_command = new Vector();
    Vector files = new Vector();
    String last_parameter = null;
    String current_arg;
    
    initCommandDictionary();
    
    if (args.length == 0) {
	  outputUsage();
	  System.exit(0);
	}
    
    for (int i = 0; i < args.length; i ++) {
	  current_arg = args[i];
      
	  /* since java is so *FUCKED* up, we parse the quotes ourselves. */
	  if (current_arg.charAt(0) == '"') {
        int j = i;
        
        current_arg = current_arg.substring(1);
        
        if (current_arg.indexOf('"') == -1) /* if the quotes don't 
                                               begin and end here. */
          for (j = i + 1; j < args.length; j ++)
            if (args[j].indexOf('"') == -1) {
              current_arg += " " + args[j];
            }
            else {
              String end_arg = args[j];
              end_arg = end_arg.substring(0, end_arg.indexOf('"'));
              current_arg += " " + end_arg;
		      break;
		    }
        
        i = j;
      }
      
	  if ((last_parameter != null
	       && last_parameter.equals("-m"))
	      ||
	      current_arg.charAt(0) == '-') {
        if (cvs_command == -1)
          parameters_before_command.addElement(current_arg);
        else
          parameters_after_command.addElement(current_arg);
        
        last_parameter = current_arg;
      }
	  else {
        if (cvs_command == -1) {
          try {
		    cvs_command = ((Integer)m_commandDictionary.get(current_arg)).intValue();
		  }
		  catch (Exception e) {
            if (CVSDebug.isDebuggingOn()) {
			  CVSDebug.debug("Unknown command : " + current_arg);
			  e.printStackTrace();
			}
            
            outputUsage();
            System.exit(0);
          }
		}
        else
          files.addElement(current_arg);
      }
	}
    
    /* handle parameters that cause us to just output something and exit */
    for (int i = 0; i < parameters_before_command.size(); i ++) {
	  String param = (String)parameters_before_command.elementAt(i);
      
	  if (param.equals("-v")) {
        outputVersion();
        System.exit(0);
      }
	  else if (param.equals("--help-commands")) {
        outputCommandList();
        System.exit(0);
      }
	}
    
    if (cvs_command == -1) {
	  outputUsage();
	  System.exit(0);
	}
    
    /* debug spew */
    if (CVSDebug.isDebuggingOn()) {
	  Enumeration cvs_param_enumeration = parameters_before_command.elements();
	  Enumeration command_param_enumeration = parameters_after_command.elements();
	  Enumeration filename_enumeration = files.elements();
      
	  CVSDebug.debug ("cvs params: ");
	  while (cvs_param_enumeration.hasMoreElements()) {
        String param = (String)cvs_param_enumeration.nextElement();
        CVSDebug.debug("    " + param + " ");
      }
	  CVSDebug.debug("");
	  CVSDebug.debug("cvs_command = " + cvs_command);
	  CVSDebug.debug("command params: ");
	  while (command_param_enumeration.hasMoreElements()) {
        String param = (String)command_param_enumeration.nextElement();
        CVSDebug.debug ("    " + param + " ");
      }
	  CVSDebug.debug("");
	  CVSDebug.debug ("filenames: ");
	  while (filename_enumeration.hasMoreElements()) {
        String param = (String)filename_enumeration.nextElement();
        CVSDebug.debug("    " + param + " ");
      }
	  CVSDebug.debug("");
	}
    
    performCommandOnFiles(parameters_before_command, cvs_command,
                          parameters_after_command, files);
    }

  public void setConnectionClosed(boolean flag) {
    m_connectionClosed = flag;
  }

  public boolean getConnectionClosed() {
    return m_connectionClosed;
  }

  public static void main(String args[]) {
    CVSText cvs = new CVSText();
    
    cvs.handleCommandLine(args);
  }

  private Hashtable m_commandDictionary;
  private boolean m_connectionClosed;
}
