/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.ui.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

public class CVSView extends CVSUI
{
  public CVSView()
    {
      command_table = new Hashtable();
    }

  protected void addMenu(JMenuBar menuBar, String menu_name, String[] menu_spec)
    {
      int i;
      JMenu menu = (JMenu)menuBar.add(new JMenu(menu_name));

      for (i = 0; i < menu_spec.length; i ++)
	{
	  if (menu_spec[i].equals("<sep>"))
	    {
	      menu.add(new JSeparator());
	    }
	  else
	    {
	      Action action = (Action)command_table.get(menu_spec[i]);

	      if (action != null)
		menu.add(action);
	    }
	}
    }

  protected JToolBar addToolBar(String[] toolbar_spec)
    {
      JToolBar toolbar = new JToolBar();
      int i;

      for (i = 0; i < toolbar_spec.length; i ++)
	{
	  if (toolbar_spec[i].equals("<sep>"))
	    {
	      toolbar.addSeparator();
	    }
	  else
	    {
	      Action action = (Action)command_table.get(toolbar_spec[i]);

	      if (action != null)
		toolbar.add(action);
	    }
	}

      return toolbar;
    }

  public JFrame getFrame()
    {
      return m_frame;
    }

  public JLabel getStatusBar()
    {
      return m_label;
    }

  public CVSUI getUI()
    {
      return this;
    }

  protected JFrame m_frame;
  protected JLabel m_label;
  protected Hashtable command_table;
}
