/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.util.*;

import javax.swing.table.*;
import javax.swing.event.*;

import java.io.*;

public class CVSTableModel extends AbstractTableModel
{
  public static final int NAME_COLUMN = 0;
  public static final int REVISION_COLUMN = 1;
  public static final int STATUS_COLUMN = 2;

  public int getColumnCount()
    {
      return 3;
    }

  public int getRowCount()
    {
      return m_fileNames.length;
    }

  public String getColumnName(int column_index)
    {
      switch (column_index)
	{
	case NAME_COLUMN:
	  return "Name";
	case REVISION_COLUMN:
	  return "Revision";
	case STATUS_COLUMN:
	  return "Status";
	default:
	  return null;
	}
    }

  public Object getValueAt(int row_index,
			   int column_index)
    {
      switch (column_index)
	{
	case NAME_COLUMN:
	  {
	    return m_fileNames[ row_index ];
	  }
	case REVISION_COLUMN:
	  {
	    CVSEntriesLine entry =
	      m_entries.getEntryForFile(m_fileNames[row_index]);

	    if (entry != null) 
	      return entry.getVersion();
	    else
	      return "???";
	  }	    
	case STATUS_COLUMN:
	  {
	    return "???";
	  }
	default:
	  {
	    return null;
	  }
	}
    }

  public void setDirectory(File dir,
			   CVSEntries entries,
			   FilenameFilter filter)
    {
      m_directory = dir;
      m_entries = entries;
      m_fileNames = m_directory.list(filter);

      fireTableStructureChanged();
    }

  public String[] getNames(int indices[])
    {
      String[] names = new String[indices.length];
      int i;

      for (i = 0; i < indices.length; i++)
	names[i] = m_fileNames[i];

      return names;
    }

  private File m_directory;
  private String m_fileNames[];
  private CVSEntries m_entries;
}
