/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.ui.*;
import com.hungry.javacvs.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;

public class CVSProjectView extends CVSView
{
  class UIListener implements CVSUIListener
  {
    public void uiChanged(CVSUIEvent e)
      {
	if (e instanceof CVSUIStatusEvent)
	  {
	    CVSUIStatusEvent se = (CVSUIStatusEvent)e;
	    getStatusBar().setText(se.getStatus());
	  }
	else if (e instanceof CVSUIPasswordEvent)
	  {
	    String passwd;

	    CVSDebug.debug("Prompt user for password");
	    passwd = JOptionPane.showInputDialog(null, "Please enter your password", "Password",
						 JOptionPane.QUESTION_MESSAGE);

	    if (passwd != null)
	      {
		getClient().getPass().setPasswordForRepository(passwd,
							       getClient().getRoot().toString());
	      }
	  }
	else if (e instanceof CVSUIRequestErrorEvent)
	  {
	    CVSUIRequestErrorEvent re = (CVSUIRequestErrorEvent)e;
	    JOptionPane.showMessageDialog(null, re.getErrorMessage(), "Error",
					  JOptionPane.ERROR_MESSAGE);
	  }
	else if (e instanceof CVSUIMessageEvent)
	  {
	    /* do nothing */
	  }
      }
  }

  class CVSTreeListener implements TreeSelectionListener
  {
    public void valueChanged(TreeSelectionEvent e)
      {
	if (e.getPaths().length > 1)
	  {
	    CVSTreeNode last_node = (CVSTreeNode)e.getPath().getLastPathComponent();

	    /* otherwise set the CVSClient's dir to the directory we
	       clicked on, and tell the table model it needs to
	       change. */
	    getClient().setDir(last_node.getPath());
	    m_tableModel.setDirectory(last_node.getDir(),
				      getClient().getEntries(),
				      getClient().getIgnore());
	  }
      }
  }

  class AddFileToProjectAction extends AbstractAction
  {
    public AddFileToProjectAction()
      {
	super("AddFileToProject");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class RemoveFileFromProjectAction extends AbstractAction
  {
    public RemoveFileFromProjectAction()
      {
	super("RemoveFileFromProject");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class UpdateAction extends AbstractAction
  {
    public UpdateAction()
      {
	super("Update");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class CommitAction extends AbstractAction
  {
    public CommitAction()
      {
	super("Commit");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class ShowLogAction extends AbstractAction
  {
    public ShowLogAction()
      {
	super("ShowLog");
      }

    public void actionPerformed(ActionEvent e) 
      {
	Vector files = new Vector();

	files.addElement("Makefile");

	CVSMessageDialog new_dialog = new CVSMessageDialog((CVSView)getUI());

	getUI().performCommandOnFiles(new Vector(), /* cvs_params */
				      CVSUI.CMD_LOG,
				      new Vector(), /* command_params */
				      files);

	new_dialog.show();
      }
  }

  class ShowStatusAction extends AbstractAction
  {
    public ShowStatusAction()
      {
	super("ShowStatus");
      }

    public void actionPerformed(ActionEvent e) 
      {
	Vector files = new Vector();
	String[] selected_names = m_tableModel.getNames(m_table.getSelectedRows());
	int i;

	for (i = 0; i < selected_names.length; i ++)
	  files.addElement(selected_names[i]);

	CVSMessageDialog new_dialog = new CVSMessageDialog((CVSView)getUI());

	getUI().performCommandOnFiles(new Vector(), /* cvs_params */
				      CVSUI.CMD_STATUS,
				      new Vector(), /* command_params */
				      files);

	new_dialog.show();
      }
  }

  class EditAction extends AbstractAction
  {
    public EditAction()
      {
	super("Edit");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class UneditAction extends AbstractAction
  {
    public UneditAction()
      {
	super("Unedit");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class WatchAction extends AbstractAction
  {
    public WatchAction()
      {
	super("Watch");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class EditWatchesAction extends AbstractAction
  {
    public EditWatchesAction()
      {
	super("EditWatches");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class CloseViewAction extends AbstractAction
  {
    public CloseViewAction()
      {
	super("CloseView");
      }

    public void actionPerformed(ActionEvent e) 
      {
	getFrame().hide();
      }
  }


  class UpdateProjectAction extends AbstractAction
  {
    public UpdateProjectAction()
      {
	super("UpdateProject");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class EditProjectAction extends AbstractAction
  {
    public EditProjectAction()
      {
	super("EditProject");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  class AboutAction extends AbstractAction
  {
    public AboutAction()
      {
	super("About");
      }

    public void actionPerformed(ActionEvent e) 
      {
      }
  }

  public static int WIDTH = 300;
  public static int HEIGHT = 400;

  private JMenuBar constructMenuBar() 
    {
      JMenuBar menuBar = new JMenuBar();

      addMenu(menuBar, "File", file_menu);
      addMenu(menuBar, "Project", project_menu);
      addMenu(menuBar, "Help", help_menu);

      return menuBar;
    }

  public JComponent createTree()
    {
      m_treeModel = new CVSTreeModel();

      /* XXX */
      m_treeModel.setDirectory(new File(System.getProperty("user.dir")));

      JTree tree = new JTree(m_treeModel);

      tree.addTreeSelectionListener(new CVSTreeListener());

      return new JScrollPane(tree);
    }

  public JComponent createTable()
    {
      JScrollPane scroll_pane;

      m_tableModel = new CVSTableModel();

      /* XXX */
      getUI().getClient().setDir(System.getProperty("user.dir"));
      m_tableModel.setDirectory(new File(System.getProperty("user.dir")),
				getClient().getEntries(),
				getClient().getIgnore());

      m_table = new JTable(m_tableModel);

      m_table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
      m_table.setShowHorizontalLines(false);

      scroll_pane = new JScrollPane(m_table,
				    JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				    JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);

      return scroll_pane;
    }

  public JSplitPane createSplitPane()
    {
      JSplitPane split_pane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
					     true /* continuous layout */);

      split_pane.setLeftComponent(createTree());
      split_pane.setRightComponent(createTable()); /* XXX */

      return split_pane;
    }

  public CVSProjectView()
    {
      super();

      JToolBar toolbar;

      initializeCommands();

      m_frame = new JFrame("CVS Project");

      toolbar = addToolBar(toolbar_spec);
      m_label = new JLabel("Status");

      m_frame.getContentPane().setLayout(new BorderLayout());
      
      m_frame.setJMenuBar(constructMenuBar());
      m_frame.getContentPane().add(toolbar, BorderLayout.NORTH);

      m_frame.getContentPane().add(m_label, BorderLayout.SOUTH);

      m_frame.getContentPane().add(createSplitPane(), BorderLayout.CENTER);

      m_frame.pack();

      addCVSUIListener(new UIListener());
    }

  public void show()
    {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

      m_frame.setSize(WIDTH, HEIGHT);
      m_frame.setLocation(screenSize.width/2 - WIDTH/2,
			screenSize.height/2 - HEIGHT/2);
      m_frame.setVisible(true);

      m_frame.validate();
      m_frame.repaint();
    }

  private void initializeCommands()
    {
      /* initialize the commands that this view can perform */

      /* file */
      command_table.put("AddFileToProject", new AddFileToProjectAction());
      command_table.put("RemoveFileFromProject", new RemoveFileFromProjectAction());
      command_table.put("Update", new UpdateAction());
      command_table.put("Commit", new CommitAction());
      command_table.put("ShowLog", new ShowLogAction());
      command_table.put("ShowStatus", new ShowStatusAction());
      command_table.put("Edit", new EditAction());
      command_table.put("Unedit", new UneditAction());
      command_table.put("Watch", new WatchAction());
      command_table.put("EditWatches", new EditWatchesAction());
      command_table.put("CloseView", new CloseViewAction());

      /* project */
      command_table.put("UpdateProject", new UpdateProjectAction());
      command_table.put("EditProject", new EditProjectAction());

      /* help */
      command_table.put("About", new AboutAction());
    }

  private String[] toolbar_spec = {
    "Update",
    "Commit",
    "ShowLog",
    "ShowStatus",
    "<sep>",
    "<sep>",
    "<sep>"
  };

  private String[] project_menu = {
    "UpdateProject",
    "EditProject",
  };

  private String[] file_menu = {
    "AddFileToProject",
    "RemoveFileFromProject",
    "<sep>",
    "Update",
    "Commit",
    "<sep>",
    "ShowLog",
    "ShowStatus",
    "Edit",
    "Unedit",
    "<sep>",
    "Watch",
    "EditWatches",
    "<sep>",
    "CloseView"
  };

  private String[] help_menu = {
    "About"
  };

  private JTable m_table;
  private CVSTableModel m_tableModel;
  private CVSTreeModel m_treeModel;

  private JTree m_tree;
};
