/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.util.*;

import javax.swing.table.*;
import javax.swing.event.*;

import java.io.*;
import java.util.*;

public class CVSProjectTableModel extends AbstractTableModel
{
  public static final int MODULE_COLUMN = 0;
  public static final int TAG_COLUMN = 1;

  public CVSProjectTableModel(CVSProject project)
    {
      slurpProject(project);
    }

  public int getColumnCount()
    {
      return 2;
    }

  public int getRowCount()
    {
      return m_moduleCount;
    }

  public String getColumnName(int column_index)
    {
      switch (column_index)
	{
	case MODULE_COLUMN:
	  return "Module";
	case TAG_COLUMN:
	  return "Tag";
	default:
	  return null;
	}
    }

  public Object getValueAt(int row_index,
			   int column_index)
    {
      switch (column_index)
	{
	case MODULE_COLUMN:
	  return m_moduleNames[ row_index ];
	case TAG_COLUMN:
	  return m_moduleTags[ row_index ];
	default:
	  return null;
	}
    }

  public boolean isCellEditable(int rowIndex,
				int columnIndex)
    {
      return true;
    }

  private void slurpProject(CVSProject project)
    {
      Enumeration modules;
      String module;
      int i;

      m_project = project;
      m_moduleCount = 0;

      modules = m_project.getModuleEnumeration();

      while (modules.hasMoreElements() 
	     && modules.nextElement() != null)
	m_moduleCount++;

      m_moduleNames = new String [ m_moduleCount ];
      m_moduleTags = new String [ m_moduleCount ];

      i = 0;
      while (modules.hasMoreElements() 
	     && (module = (String)modules.nextElement()) != null)
	{
	  m_moduleNames[ i ] = module;
	  m_moduleTags[ i ] = m_project.tagForModule(module);
	  i++;
	}
    }

  public void setProject(CVSProject project)
    {
      slurpProject(project);

      fireTableStructureChanged();
    }

  private CVSProject m_project;
  private String m_moduleNames[];
  private String m_moduleTags[];
  private int m_moduleCount;
}
