/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.ui.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

public class CVSMainView extends CVSView
{
  class ExitAction extends AbstractAction
  {
    public ExitAction()
      {
	super("Exit");
      }

    public void actionPerformed(ActionEvent e)
      {
	System.exit(0);
      }
  }
  
  class NewProjectAction extends AbstractAction
  {
    public NewProjectAction()
      {
	super("NewProject");
      }

    public void actionPerformed(ActionEvent e)
      {
	CVSNewProjectDialog dlg = new CVSNewProjectDialog(getFrame());
	dlg.show();
      }
  }
  
  class OpenProjectAction extends AbstractAction
  {
    public OpenProjectAction()
      {
	super("OpenProject");
      }

    public void actionPerformed(ActionEvent e)
      {
	CVSProjectView project_view = new CVSProjectView();
	project_view.show();
      }
  }

  class AboutAction extends AbstractAction
  {
    public AboutAction()
      {
	super("About");
      }

    public void actionPerformed(ActionEvent e)
      {
      }
  }

  public static int WIDTH = 500;
  public static int HEIGHT = 400;

  private JMenuBar constructMenuBar() 
    {
      JMenuBar menuBar = new JMenuBar();

      addMenu(menuBar, "File", file_menu);
      addMenu(menuBar, "Help", help_menu);

      return menuBar;
    }

  public CVSMainView()
    {
      initializeCommands();

      m_frame = new JFrame("Hungry CVS");

      m_frame.getContentPane().setLayout(new BorderLayout());
      
      m_frame.setJMenuBar(constructMenuBar());
      m_frame.getContentPane().add(new JButton("Hello, world"), BorderLayout.CENTER);


      m_frame.pack();
    }

  public void show()
    {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

      m_frame.setSize(WIDTH, HEIGHT);
      m_frame.setLocation(screenSize.width/2 - WIDTH/2,
			screenSize.height/2 - HEIGHT/2);
      m_frame.setVisible(true);

      m_frame.validate();
      m_frame.repaint();
    }

  private String[] file_menu = {
    "NewProject",
    "OpenProject",
    "<sep>",
    "Exit",
  };

  private String[] help_menu = {
    "About"
  };

  private void initializeCommands()
    {
      /* initialize the commands that this view can perform */
      command_table.put("Exit", new ExitAction());
      command_table.put("NewProject", new NewProjectAction());
      command_table.put("OpenProject", new OpenProjectAction());
      command_table.put("About", new AboutAction());
    }
};
