/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.composer_plugin;

import com.hungry.javacvs.util.*;
import com.hungry.javacvs.client.*;
import com.hungry.javacvs.client.ui.*;
import com.hungry.javacvs.client.util.*;

import java.io.*;
import netscape.security.*;
import netscape.plugin.composer.*;
import netscape.plugin.composer.io.*;

public class CVSComposerPlugin extends Plugin 
{
  public CVSComposerPlugin()
    {
      CVSDebug.debug("In CVSComposerPlugin()");
      
      m_privMgr = PrivilegeManager.getPrivilegeManager();
      m_principal = PrivilegeManager.getMyPrincipals()[0];
      
      m_target = (UserTarget)Target.findTarget("CVSRemoteAccess", m_principal);
      if (m_target == null)
	{
	  Target targets[] = new Target[4];

	  targets[0] = Target.findTarget("UniversalExecAccess");
	  targets[1] = Target.findTarget("UniversalPropertyRead");
	  targets[2] = Target.findTarget("UniversalFileAccess");
	  targets[3] = Target.findTarget("UniversalConnect");
	  
	  m_target = new UserTarget("CVSRemoteAccess", m_principal,
				    UserDialogHelper.targetRiskHigh(),
				    UserDialogHelper.targetRiskColorHigh(),
				    "Accessing CVS administrative files on your local disk and " +
				    "opening a network connection to a remote CVS server",
				    "http://www.hungry.com/products/java/cvsclient/composer_plugin/CVSRemoteAccess.html",
				    targets);
	  m_target.registerTarget();
	}
      else
	{
	  CVSDebug.debug("CVSRemoteAccess target already exists.... hmm....");
	}
    }
  
  protected void enableTarget()
    {
      m_privMgr.enablePrivilege(m_target);
    }
  
  protected void disableTarget()
    {
      m_privMgr.disablePrivilege(m_target);
    }
  
  protected void checkTarget()
    {
      m_privMgr.checkPrivilegeEnabled(m_target);
    }
  
  private UserTarget m_target = null;
  private Principal m_principal = null;
  private PrivilegeManager m_privMgr = null;
}
