/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.requests;

import com.hungry.javacvs.client.handlers.*;
import com.hungry.javacvs.client.util.*;
import com.hungry.javacvs.util.*;

import java.io.*;
import java.util.*;

public abstract class CVSRequest
{
  public CVSRequest(CVSConnection c) {
    setConnection(c);
  }

  public CVSRequest() {
  }

  public synchronized void setConnection(CVSConnection c) {
    m_conn = c;
  }

  public abstract CVSResponseHandler makeRequest() throws IOException;
  
  protected CVSConnection m_conn;

  static private Vector m_enabledrequests;

  static public void invalidateAllRequests() {
    if (m_enabledrequests == null)
      m_enabledrequests = new Vector();
    else
      m_enabledrequests.removeAllElements();
  }

  static public void enableRequest(String request_name) {
    m_enabledrequests.addElement(request_name);
  }
  
  static public boolean isRequestEnabled(String request_name) {
    return m_enabledrequests.contains(request_name);
  }

  static public void dumpValidRequests() {
    if (m_enabledrequests != null) {
      Enumeration enum;
    
      CVSDebug.debug("Valid-requests: ");
      
      enum = m_enabledrequests.elements();
      
      while (enum.hasMoreElements()) {
        String request_foo = (String)enum.nextElement();
        
        CVSDebug.debug("+  " + request_foo);
      }
    }
  }
}
