/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.requests;

import com.hungry.javacvs.client.util.*;
import com.hungry.javacvs.util.*;

import java.util.*;
import java.io.*;

public abstract class CVSArgRequest extends CVSRequest
{
  public CVSArgRequest()
    {
      m_array = new Vector();
    }
  
  public void addArgument(String arg)
    {
      // XXX doesn't handle multi line arguments yet.
      m_array.addElement(arg);
    }
  
  public void addArgument(File arg)
    {
      m_array.addElement(arg);
    }

  public void addArgument(CVSMode arg)
    {
      m_array.addElement(arg);
    }

  protected void outputArguments() throws IOException
  {
    Enumeration enum = m_array.elements();
    Object arg;
    
    while (enum.hasMoreElements() && (arg = enum.nextElement()) != null)
      {
	if (arg instanceof String)
	  //  XXX doesn't handle multi line arguments yet.
	  m_conn.writeString("Argument " + arg + "\n");
	else if (arg instanceof File)
	  {
	    /* hack to send file contents across. */
	    FileInputStream i_stream = new FileInputStream((File)arg);
	    byte[] buf = new byte[1024];
	    int num_left_to_write;
	    
	    num_left_to_write = (int)((File)arg).length();
	    
	    m_conn.writeString((new Integer(num_left_to_write)).toString() + "\n");
	    
	    while (num_left_to_write > 1024)
	      {
		i_stream.read(buf);
		m_conn.writeBytes(buf);
		
		num_left_to_write -= 1024;
	      }
	    
	    i_stream.read(buf, 0, num_left_to_write);
	    m_conn.writeBytes(buf, 0, num_left_to_write);
	    
	    i_stream.close();
	  }
	else if (arg instanceof CVSMode)
	  {
	    m_conn.writeString(arg.toString() + "\n");
	  }
      }
  }
  
  protected Vector m_array;
}
