/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.i18n;

import java.util.*;

public class CVSStrings extends ResourceBundle
{
  public static final String OPENING_CONNECTION = "OPENING_CONNECTION";
  public static final String AUTHENTICATING = "AUTHENTICATING";
  public static final String DETERMINING_VALID_REQUESTS = "DETERMINING_VALID_REQUESTS";
  public static final String SENDING_VALID_RESPONSES = "SENDING_VALID_RESPONSES";
  public static final String SETTING_ROOT_AND_REPOSITORY = "SETTING_ROOT_AND_REPOSITORY";
  public static final String SENDING_REQUEST = "SENDING_REQUEST";
  public static final String READING_RESPONSE = "READING_RESPONSE";
  public static final String DONE = "DONE";

  public static final String INVALID_PASSWORD = "INVALID_PASSWORD";

  public static ResourceBundle strings()
    {
      return the_strings;
    }

  protected CVSStrings()
    {
      m_dict = new Hashtable();
    }

  public Object handleGetObject(String key)
    {
      return m_dict.get(key);
    }

  public Enumeration getKeys()
    {
      return m_dict.keys();
    }

  protected Hashtable m_dict;
  private static ResourceBundle the_strings;

  static {
    the_strings = ResourceBundle.getBundle("com.hungry.javacvs.client.i18n.resources.CVSStrings");
  }
}
