/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.util.*;

public class CVSEntriesLine
{
  public CVSEntriesLine(String line) throws CVSInvalidEntriesLine
    {
      try {
	int slash_index;
	String name;
	String version; 
	String date_or_tag;
	String foo;
	
	if (line.charAt(0) == 'D')
	  {
	    m_isdir = true;
	    line = line.substring(2);
	  }
	else // line.charAt(0) == '/'
	  line = line.substring(1);
	
	if ((slash_index = line.indexOf('/')) == -1)
	  {
	    return; // XXX should probably raise an exception...
	  }
	name = line.substring(0, slash_index);
	line = line.substring(slash_index + 1);
	
	if ((slash_index = line.indexOf('/')) == -1)
	  {
	    return; // XXX should probably raise an exception...
	  }
	version = line.substring(0, slash_index);
	line = line.substring(slash_index + 1);
	
	if ((slash_index = line.indexOf('/')) == -1)
	  {
	    return; // XXX should probably raise an exception...
	  }
	date_or_tag = line.substring(0, slash_index);
	line = line.substring(slash_index + 1);
	
	if ((slash_index = line.indexOf('/')) == -1)
	  {
	    return; // XXX should probably raise an exception...
	  }
	foo = line.substring(0, slash_index);
	
	setName(name);
	setVersion(version);
	setTagOrDate(date_or_tag);
	setOptions(foo); //XXXX ???
      }
      catch (Exception e) {
	throw new CVSInvalidEntriesLine();
      }
    }

  public void setName(String name)
    {
      m_name = name.trim();
    }

  public String getName()
    {
      return m_name;
    }
  
  public void setVersion(String version)
    {
      m_version = version.trim();
    }

  public String getVersion()
    {
      return m_version;
    }

  public void setDir(boolean is_dir)
    {
      m_isdir = is_dir;
    }
     
  public boolean getDir()
    {
      return m_isdir;
    }

  public void setConflict(String conflict)
    {
      m_conflict = conflict.trim();
    }

  public String getConflict()
    {
      return m_conflict;
    }
  
  public void setOptions(String options)
    {
      m_options = options.trim();
    }

  public String getOptions()
    {
      return m_options;
    }
  
  public void setTag(String tag)
    {
      m_istag = true;
      m_tag_or_date = tag.trim();
    }

  public void setDate(String date)
    {
      m_istag = false;
      m_tag_or_date = date.trim();
    }

  public String getTag()
    {
      if (m_tag_or_date == null)
	return "";
      else
	return "T" + m_tag_or_date;
    }

  private static String short_months[] = { 
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
    "Aug", "Sep", "Oct", "Nov", "Dec" 
  };

  private static String long_months[] = {
    "January", "February", "March", "April", "May", "June", "July",
    "August", "September", "October", "November", "December"
  };

  private static Hashtable month_mappings;

  private String convertDateToJava(String date)
    {
      String converted_date;
      String year, month, day, time;
      int hour;
      boolean pm = false;

      /* CVS stores dates in the entries file in the following format:

	 Sat Jan 10 07:49:12 1998

	 Java requires the dates to be in the following format (for
	 the LONG format)

	 January 10, 1998 7:49:12 AM
	 
      */
      synchronized(this) {
	if (month_mappings == null)
	  {
	    int i;
	    month_mappings = new Hashtable();
	    
	    for (i = 0; i < short_months.length; i ++)
	      month_mappings.put(short_months[i], long_months[i]);
	  }
      }

      /* we skip the weekday at the start. */
      date = date.substring(3).trim();
      year = date.substring(date.length() - 4);
      date = date.substring(0, date.length() - 5).trim();

      month = date.substring(0, 3);
      date = date.substring(4).trim();

      day = date.substring(0, 2).trim();
      date = date.substring(2).trim();

      hour = (new Integer(date.substring(0,2))).intValue();
      date = date.substring(2).trim();
      if (hour > 12)
	{
	  hour -= 12;
	  pm = true;
	}

      converted_date = (String)month_mappings.get(month) + " " + day + ", " + year + " " + hour + date + (pm ? " PM" : " AM");

      return converted_date;
    }

  public String getCVSDate()
    {
      if (m_tag_or_date == null)
	return "";
      else
	return m_tag_or_date;
    }

  public String getDate()
    {
      if (m_tag_or_date == null)
	return "";
      else if (!m_istag)
	return convertDateToJava(m_tag_or_date);
      else
	return m_tag_or_date;
    }

  public void setTagOrDate(String tag_or_date)
    {
      if (tag_or_date.length() == 0)
	m_istag = false;
      else if (tag_or_date.indexOf(' ') != -1)
	{
	  setDate(tag_or_date);
	}
      else
	{
	  setTag(tag_or_date.substring(1));
	}
    }

  public String getTagOrDate()
    {
      if (m_istag)
	return getTag();
      else
	return getDate();
    }

  public String toString()
    {
      return (m_isdir ? "D" : "") + "/" + getName() + "/" + getVersion() + "/" + getCVSDate() + "/" + "/";
    }

  private String m_name;
  private String m_version;
  private String m_conflict;
  private String m_options;
  private boolean m_istag;
  private String m_tag_or_date;
  private boolean m_isdir;
}
