/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.util.*;
import java.io.*;

/** Class to read and write dates in the format expected by the existing CVS client */
public class CVSDate
{
  public CVSDate(String date_string) throws CVSInvalidDateString
    {
      int i;
      String wday;
      String mo;

      /* first thing is the weekday. */
      if (date_string.length() < 4)
	  throw new CVSInvalidDateString();
      wday = date_string.substring(0, 3);
      date_string = date_string.substring(4);
      for (i = 0; i < weekdays.length; i ++)
	if (wday.equals(weekdays[i]))
	  {
	    weekday = i;
	    break;
	  }

      /* next thing is the month (in short form). */
      if (date_string.length() < 4)
	  throw new CVSInvalidDateString();
      mo = date_string.substring(0, 3);
      date_string = date_string.substring(4);
      for (i = 0; i < short_months.length; i ++)
	if (mo.equals(short_months[i]))
	  {
	    month = i;
	    break;
	  }

      /* then the day */
      if (date_string.length() < 3)
	  throw new CVSInvalidDateString();
      day = (new Integer(date_string.substring(0,2))).intValue();
      date_string = date_string.substring(3);

      /* then the hours */
      if (date_string.length() < 3)
	  throw new CVSInvalidDateString();
      hours = (new Integer(date_string.substring(0,2))).intValue();
      date_string = date_string.substring(3);

      /* then the minutes */
      if (date_string.length() < 3)
	  throw new CVSInvalidDateString();
      minutes = (new Integer(date_string.substring(0,2))).intValue();
      date_string = date_string.substring(3);

      /* then the seconds */
      if (date_string.length() < 3)
	  throw new CVSInvalidDateString();
      seconds = (new Integer(date_string.substring(0,2))).intValue();
      date_string = date_string.substring(3);

      /* then the year */
      if (date_string.length() < 4)
	  throw new CVSInvalidDateString();
      year = (new Integer(date_string.substring(0,4))).intValue();

      if (hours > 12) is_pm = true;
    }

  public CVSDate(long timestamp)
    {
      if (hours > 12) is_pm = true;
      throw new RuntimeException("CVSDate(long) not implemented yet.");
    }

  public String toJavaDate()
    {
      int real_hours = ( is_pm ? hours - 12 : hours );
      return (long_months[ month ] + " " 
	      + day + ", "
	      + year + " "
	      + ( real_hours < 10 ? "0" : "" ) + real_hours + ":"
	      + ( minutes < 10 ? "0" : "" ) + minutes + ":"
	      + ( seconds < 10 ? "0" : "" ) + seconds
	      + ( is_pm ? " PM" : " AM" ));
    }

  public static CVSDate fromJavaDate(String java_date)
    {
      throw new RuntimeException("CVSDate.fromJavaDate() not implemented");
    }

  public String toString()
    {
      return (weekdays[ weekday ] + " " +
	      short_months[ month ] + " " +
	      day + " " +
	      ( hours < 10 ? "0" : "" ) + hours + ":" +
	      ( minutes < 10 ? "0" : "") + minutes + ":" +
	      ( seconds < 10 ? "0" : "") + seconds + " " +
	      year);
    }

  public int getWeekDay()
    {
      return weekday;
    }

  public int getDay()
    {
      return day;
    }

  public int getMonth()
    {
      return month;
    }

  public int getYear()
    {
      return year;
    }

  public int getHours()
    {
      return hours;
    }

  public int getMinutes()
    {
      return minutes;
    }

  public int getSeconds()
    {
      return seconds;
    }

  private boolean is_pm;
  private int weekday;
  private int day;
  private int month;
  private int year;
  private int hours;
  private int minutes;
  private int seconds;

  public static String weekdays[] = {
    "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"
  };

  public static String short_months[] = { 
    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
    "Aug", "Sep", "Oct", "Nov", "Dec" 
  };

  public static String long_months[] = {
    "January", "February", "March", "April", "May", "June", "July",
    "August", "September", "October", "November", "December"
  };

  private static Hashtable month_mappings;

  static {
    int i;
    month_mappings = new Hashtable();
    
    for (i = 0; i < short_months.length; i ++)
      month_mappings.put(short_months[i], long_months[i]);
  }

  /**
   * a little test harness for dates.
   * reads CVS styled dates, one per line, from System.in, and decomposes them, prints
   * out the java equivalent, and reconstructs the CVS date (using toString()).
   */
  public static void main(String args[])
    {
      LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
      String line;

      try {
        while ((line = reader.readLine()) != null) {
          try {
	    System.out.println("Inputted line:  " + line);
	    
	    CVSDate date = new CVSDate(line);
	    
	    System.out.println("Java format:    " + date.toJavaDate());
	    System.out.println("CVS format:     " + date.toString());
	  }
	  catch (CVSInvalidDateString e)
	    {
	      System.out.println("Invalid date.");
	    }
	}
      }
      catch (IOException e)
        {
	  e.printStackTrace();	    
	}
    }
}
