/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.util;

import com.hungry.javacvs.util.*;

import java.net.*;
import java.io.*;

public class CVSServerSocket
{
  protected CVSServerSocket(ServerSocket socket, int method) {
    m_serverSocket = socket;
    m_method = method;
  }
  
  public CVSServerConnection accept() {
    try {
      Socket socket = m_serverSocket.accept();
      
      return createConnection(socket);
    }
    catch (IOException e) {
      e.printStackTrace();
      return null;
    }
  }

  public CVSServerConnection createConnection(Socket socket) {
    try {
      if (m_method == CVSRoot.PSERVER_METHOD)
        return new CVSServerPServerConnection(socket);
      else if (m_method == CVSRoot.JSERVER_METHOD)
        return new CVSServerJServerConnection(socket);
      else
        return null;
    }
    catch (IOException e) {
      e.printStackTrace();
      return null;
    }
  }

  public static CVSServerSocket createSocketForMethod(int method) {
    try {
      if (method == CVSRoot.PSERVER_METHOD)
        return new CVSServerSocket(new ServerSocket(CVSConnection.CVS_PSERVER_PORT),
                                   method);
      else if (method == CVSRoot.JSERVER_METHOD)
        return new CVSServerSocket(new ServerSocket(CVSConnection.CVS_JSERVER_PORT),
                                   method);
      else
        return null;
    }
    catch (IOException e) {
      e.printStackTrace();
      return null;
    }
  }
  
  protected ServerSocket m_serverSocket;
  protected int m_method;
}
