/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.util;

import com.hungry.javacvs.util.*;

import java.security.*;
import java.net.*;
import java.io.*;

public class CVSServerJServerConnection extends CVSServerConnection
{
  public CVSServerJServerConnection(Socket socket) throws IOException
    {
      super(socket);
    }
  
  public int authenticateUser() throws IOException
    {
      try {
	String root, login, tmp;
	int sig_length;
	Signature verifyalg = Signature.getInstance("DSA");
	byte signature[];
	IdentityScope system_scope = IdentityScope.getSystemScope();
	Identity user;
	PublicKey key;
	FileInputStream stream;
	Certificate cert = new sun.security.x509.X509Cert();

	root = readLine().trim();
	login = readLine().trim();

	stream = new FileInputStream(root +
				     File.separator +
				     "CVSROOT" +
				     File.separator +
				     "certs" + 
				     File.separator +
				     login + ".509");
	cert.decode(stream);
	
	stream.close();

	user = system_scope.getIdentity(cert.getPublicKey());
	
	tmp = readLine();
	
	if (!tmp.equals(END_DSA_AUTH_REQUEST))
	  {
	    writeString(AUTH_NACK);
	    return AUTHENTICATION_FAILED;
	  }
	
	/* XXX use a better seed */
	byte buf[];
	SecureRandom secrand = new SecureRandom();
	secrand.setSeed(0);
	
	buf = new byte[4096];
	secrand.nextBytes(buf);

	writeString(AUTH_PARTIAL_ACK);
	
	writeString(buf.length + "\n");
	writeBytes(buf);

	sig_length = new Integer(readLine().trim()).intValue();
	signature = new byte[sig_length];
	readBytes(signature);

	verifyalg.initVerify(user.getPublicKey());
	verifyalg.update(buf);
	
	if (verifyalg.verify(signature))
	  {
	    writeString(AUTH_ACK);
	    return AUTHENTICATION_SUCCESSFUL;
	  }
	else
	  {
	    writeString(AUTH_NACK);
	    return AUTHENTICATION_FAILED;
	  }
      }
      catch (NoSuchAlgorithmException e)
	{
	  e.printStackTrace();
	  System.err.println("Couldn't get an instance of the DSA algorithm.");

	  writeString(AUTH_NACK);
	  return AUTHENTICATION_FAILED;
	}
      catch (InvalidKeyException e)
	{
	  e.printStackTrace();

	  writeString(AUTH_NACK);
	  return AUTHENTICATION_FAILED;
	}
      catch (KeyException e)
	{
	  e.printStackTrace();

	  writeString(AUTH_NACK);
	  return AUTHENTICATION_FAILED;
	}
      catch (SignatureException e)
	{
	  e.printStackTrace();

	  writeString(AUTH_NACK);
	  return AUTHENTICATION_FAILED;
	}
    }
      
  public int verifyUser() throws IOException
    {
      String root, login, tmp;
	  
      root = readLine();
      login = readLine();

      tmp = readLine();
      
      if (!tmp.equals(END_DSA_VERIFICATION_REQUEST))
	{
	  writeString(AUTH_NACK);
	  return VERIFICATION_FAILED;
	}
      
      if (true /* fix me */)
	{
	  writeString(AUTH_ACK);
	  return VERIFICATION_SUCCESSFUL;
	}
      else
	{
	  writeString(AUTH_NACK);
	  return VERIFICATION_FAILED;
	}
    }

  public int checkUser()
    throws IOException
    {
      String tmp = readLine();
      
      if (tmp.equals(BEGIN_DSA_AUTH_REQUEST))
	return authenticateUser();
      else if (tmp.equals(BEGIN_DSA_VERIFICATION_REQUEST))
	return verifyUser();
      else
	{
	  writeString(AUTH_NACK);
	  return AUTHENTICATION_FAILED;
	}
    }
}
