/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 *
 * This class represents the per-thread state of a server connection.
 * Anything that can vary across connections to the server should be
 * stored in this class.
 *
 * @version $Id: CVSHandlerThreadState.java,v 1.10 1999/06/25 00:44:38 toshok Exp $
 * @author Chris Toshok
 */

package com.hungry.javacvs.server.util;

import com.hungry.javacvs.util.*;

import java.util.*;

public class CVSHandlerThreadState {
  /**
   * Create a new CVSHandlerThreadState
   */
  public CVSHandlerThreadState() {
    m_argumentArray = new Vector();
  }

  /**
   * Set this threads's idea about what the CVSROOT is.
   * @param root the CVSROOT.
   */
  public void setRoot(String root) {
    CVSDebug.debug("Setting Handler Thread State's CVSROOT to " + root);
    m_cvsroot = root;
  }
  
  public String getRoot() {
    return m_cvsroot;
  }

  /**
   * Set this thread's idea about what the CVS Repository is.
   * @param repository the CVS Repository.
   */
  public void setRepository(String repository) {
    CVSDebug.debug("Setting Handler Thread State's CVS Repository to " + repository);
    m_cvsRepository = repository;
  }

  /**
   * The client side of the client-to-server pathname mapping.
   * The client always passes filenames relative to the client directory,
   * and we convert them to be relative to the server directory.
   * @param directory the client-side directory.
   */
  public void setClientDirectory(String directory) {
    CVSDebug.debug("Setting Handler Thread State's Client Directory to " + directory);
    m_clientDirectory = directory;
  }
  
  /**
   * The server side of the client-to-server pathname mapping.
   * The client always passes filenames relative to the client directory,
   * and we convert them to be relative to the server directory.
   * @param directory the server-side directory.
   */
  public void setServerDirectory(String directory) {
    CVSDebug.debug("Setting Handler Thread State's Server Directory to " + directory);
    m_serverDirectory = directory;
  }
  
  /**
   * Enables tracing for this server thread (as in the -t command line flag).
   */
  public void enableTracing() {
    m_tracingEnabled = true;
  }
  
  /**
   * Returns whether or not tracing has been enabled for this thread.
   * @returns whether or not tracing has been enabled.
   */
  public boolean isTracingEnabled() {
    return m_tracingEnabled;
  }
  
  public void disableHistory() {
    m_historyDisabled = true;
  }
  
  public boolean isHistoryDisabled() {
    return m_historyDisabled;
  }

  public void disableDiskAccess() {
  }
  
  public boolean isDiskAccessDisabled() {
    return m_diskAccessDisabled;
  }
  
  public void beQuiet() {
    m_quietLevel = 1;
  }
  
  public void beReallyQuiet() {
    m_quietLevel = 2;
  }
  
  public int quietLevel() {
    return m_quietLevel;
  }
  
  public void enableResponse(String response) {
    /* do something spiffy here. */
  }
  
  public void addArgument(String argument) {
    CVSDebug.debug("Adding argument '" + argument + "' to thread's state.");
    
    m_argumentArray.addElement(argument);
  }

  public void addArgument(CVSFileArg argument) {
    CVSDebug.debug("Adding argument '" +
                   argument.toString() +
                   "' to thread's state.");
    
    m_argumentArray.addElement(argument);
  }
  
  public Enumeration argumentEnumeration() {
    return m_argumentArray.elements();
  }
  
  public void clearArguments() {
    m_argumentArray.removeAllElements();
  }
  
  private String m_cvsroot;
  private String m_cvsRepository;
  private String m_clientDirectory;
  private String m_serverDirectory;
  private boolean m_tracingEnabled;
  private boolean m_historyDisabled;
  private boolean m_diskAccessDisabled;
  private int m_quietLevel;

  private Vector m_argumentArray;
}
