/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.requests;

import com.hungry.javacvs.server.util.*;
import com.hungry.javacvs.util.*;

import java.net.*;
import java.io.*;
import java.util.*;

public abstract class CVSRequestHandler {
  public void setConnection(CVSConnection conn) {
    m_conn = conn;
  }

  public void setThreadState(CVSHandlerThreadState state) {
    m_state = state;
  }
  
  public abstract void handleRequest() throws IOException;

  protected CVSConnection m_conn;
  protected CVSHandlerThreadState m_state;

  public static void setupHandlers() {
    String pkg = "com.hungry.javacvs.server.requests.";
    
    if (m_handlerDictionary != null) return;
    
    m_handlerDictionary = new Hashtable();
    
    try {
      m_handlerDictionary.put("Root",
                              Class.forName(pkg + "CVSRootRequest"));
      m_handlerDictionary.put("Valid-responses",
                              Class.forName(pkg + "CVSValidResponsesRequest"));
      m_handlerDictionary.put("valid-requests",
                              Class.forName(pkg + "CVSValidRequestsRequest"));
      m_handlerDictionary.put("Directory",
                              Class.forName(pkg + "CVSDirectoryRequest"));
      m_handlerDictionary.put("Entry",
                              Class.forName(pkg + "CVSEntryRequest"));
      m_handlerDictionary.put("Modified",
                              Class.forName(pkg + "CVSModifiedRequest"));
      m_handlerDictionary.put("Unchanged",
                              Class.forName(pkg + "CVSUnchangedRequest"));
      m_handlerDictionary.put("Argument",
                              Class.forName(pkg + "CVSArgumentRequest"));
      m_handlerDictionary.put("Argumentx",
                              Class.forName(pkg + "CVSArgumentxRequest"));
      m_handlerDictionary.put("ci",
                              Class.forName(pkg + "CVSCiRequest"));
      m_handlerDictionary.put("co",
                              Class.forName(pkg + "CVSCoRequest"));
      m_handlerDictionary.put("update",
                              Class.forName(pkg + "CVSUpdateRequest"));
      m_handlerDictionary.put("diff",
                              Class.forName(pkg + "CVSDiffRequest"));
      m_handlerDictionary.put("Repository",
                              Class.forName(pkg + "CVSRepositoryRequest"));
      m_handlerDictionary.put("log",
                              Class.forName(pkg + "CVSLogRequest"));
      m_handlerDictionary.put("status",
                              Class.forName(pkg + "CVSStatusRequest"));
      m_handlerDictionary.put("add",
                              Class.forName(pkg + "CVSAddRequest"));
      m_handlerDictionary.put("Lost",
                              Class.forName(pkg + "CVSLostRequest"));
      m_handlerDictionary.put("Questionable",
                              Class.forName(pkg + "CVSQuestionableRequest"));
      m_handlerDictionary.put("remove",
                              Class.forName(pkg + "CVSRemoveRequest"));
      m_handlerDictionary.put("UseUnchanged",
                              Class.forName(pkg + "CVSUseUnchangedRequest"));
      m_handlerDictionary.put("Global_option",
                              Class.forName(pkg + "CVSGlobalOptionRequest"));
    }
    catch (Exception e) {
      System.err.println("Error while adding default handlers: " + e);
      System.exit(2);
    }
  }

  public static CVSRequestHandler getHandlerInstanceByName(String name,
                                                      CVSConnection conn,
                                                      CVSHandlerThreadState state) {
    Class handler_class = (Class)m_handlerDictionary.get(name);
    CVSRequestHandler handler = null;
    
    try {
      handler = (CVSRequestHandler)( handler_class.newInstance() );
      handler.setConnection(conn);
    }
    catch (Exception e) {
      System.err.println("Some error when creating the handler instance named " +
                         name + ": ");
      e.printStackTrace();
    }
    
    return handler;
  }
  
  public static Enumeration handlerNameEnumeration() {
    return m_handlerDictionary.keys();
  }
  
  private static Hashtable m_handlerDictionary;
}
