/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.io.Writer;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

/**
   A handy class to keep debug spew from going to the same place to
   which useful, normal output would be directed.  
*/
public class CVSLogWindow
{
    /**
       CVSLogWindowWriter allos us to use the same interface for debugging
       regardless of whether we want the spew directed at the log window
       or the users console.
     */
    class CVSLogWindowWriter extends Writer
    {
	/** flush the output stream */
	public void flush()
	{
	    /* nothing needed, since each write is "flushed" */
	}
	
	/** close the output stream */
	public void close()
	{
	    /* nothing needed, since we aren't really writing to a stream */
	}

	/** write the buffer to the output stream
	    @param buf buffer of characters to write
	    @param offset offset into buffer from which to start outputting.
	    @param len length of text to output
	*/
	public void write(char[] buf, int offset, int length)
	{
	    String append_str = new String(buf, offset, length);
	    m_textarea.append(append_str);
	}
    }

    /** The initial width of the log window */
    public static int WIDTH = 500;
    /** The initial height of the log window */
    public static int HEIGHT = 400;

    /** Construct a new log window, and show it */
    public CVSLogWindow()
    {
	JButton clear_button;
	JButton close_button;
	JPanel button_panel;

	m_frame = new JFrame("Hungry CVS");
	
	m_frame.getContentPane().setLayout(new BorderLayout());

	clear_button = new JButton("Clear");
	close_button = new JButton("Close");

	clear_button.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent ev) {
	    m_textarea.setText("");
        }});
	close_button.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent ev) {
          CVSDebug.debug("log window close pressed");
        }});

	button_panel = new JPanel();
	button_panel.setLayout(new BorderLayout());
	button_panel.add(clear_button, BorderLayout.EAST);
	button_panel.add(close_button, BorderLayout.WEST);

	m_textarea = new JTextArea(15, 80);
	m_textarea.setEditable(false);

	m_frame.getContentPane().add(button_panel, BorderLayout.SOUTH);
	m_frame.getContentPane().add(new JScrollPane(m_textarea));

	m_frame.setSize(WIDTH, HEIGHT);

	m_frame.show();
	
	m_writer = new CVSLogWindowWriter();
    }

    /** return the Writer associated with this log window. */
    public Writer getWriter()
    {
	return m_writer;
    }

    /** The Writer/ */
    private CVSLogWindowWriter m_writer;
    /** The Swing frame that encloses the log window/ */
    private JFrame m_frame;
    /** The text area into which all the text is written. */
    private JTextArea m_textarea;
}
