/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.util.*;
import java.io.*;

public class CVSEntries implements FilenameFilter
{
  public CVSEntries()
    {
      m_dict = new Hashtable();
      m_dirty = false;
    }

  public void readFromFile(File entries)
    {
      /* get rid of the old entries. */
      m_dict = new Hashtable();

      try {
	FileReader reader = new FileReader(entries);
	LineNumberReader lreader = new LineNumberReader(reader);
	String s;

	CVSDebug.debug("Trying to read " + entries.toString());
	
	while ((s = lreader.readLine()) != null)
	  addEntriesLine(s);

	CVSDebug.debug("Entries file has been read.");
      }
      catch (Exception e) {
	CVSDebug.debug("Error while reading the entries file. " + e.toString());
	e.printStackTrace(new PrintWriter(CVSDebug.getDebugWriter()));
      }

      m_dirty = false;
      m_file = entries;
    }
  
  private void writeToFile(File entries_file) throws IOException
    {
      Enumeration entries = m_dict.elements();
      FileOutputStream ostream = new FileOutputStream(entries_file);
      CVSEntriesLine entry;
      
      while (entries.hasMoreElements() 
	     && (entry = (CVSEntriesLine)entries.nextElement()) != null)
	{
	  CVSDebug.debug("writing entry for line " + entry.toString());
	  
	  ostream.write(entry.toString().getBytes());
	  ostream.write('\n');
	}
      
      ostream.close();
    }
  
  public void saveToFile() throws IOException
    {
      File tmp_file;

      if (m_dirty)
	{
	  tmp_file = new File(m_file.getAbsolutePath() + ".bak");
	  
	  writeToFile(tmp_file);
	  
	  tmp_file.renameTo(m_file);
	  
	  m_dirty = false;
	}
    }

  public void addEntriesLine(CVSEntriesLine line)
    {
      m_dict.put(line.getName(), line);
      m_dirty = true;
    }

  public void addEntriesLine(String real_line)
    {
      try {
	CVSEntriesLine entries_line;
	int slash_index;
	
	CVSDebug.debug("addEntriesLine passed " + real_line);
	
	entries_line = new CVSEntriesLine(real_line);
	
	CVSDebug.debug("read entry: " + 
		       entries_line.getName() + 
		       " - " + 
		       entries_line.toString());
	
	m_dict.put(entries_line.getName(), entries_line);
	
	m_dirty = true;
      }
      catch (CVSInvalidEntriesLine ce) {
	/* do nothing, just fall out of this method. */
      }
    }

  public CVSEntriesLine getEntryForFile(String filename)
    {
      return (CVSEntriesLine)m_dict.get(filename);
    }

  public boolean accept(File dir, String name)
    {
      if (m_dict.get(name) == null)
	return false;

      if ((new File (dir, name)).isDirectory())
	return false;

      return true;
    }

  private Hashtable m_dict;
  private boolean m_dirty;
  private File m_file;
}
