/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.util;

import java.net.*;
import java.io.*;

public class CVSConnection
{
  protected static final int STREAM_BUFFER_SIZE = 1024;
  
  public static final int CVS_PSERVER_PORT = 2401;
  protected static final String BEGIN_AUTH_REQUEST = "BEGIN AUTH REQUEST\n";
  protected static final String END_AUTH_REQUEST = "END AUTH REQUEST\n";
  protected static final String BEGIN_VERIFICATION_REQUEST =
    "BEGIN VERIFICATION REQUEST\n";
  protected static final String END_VERIFICATION_REQUEST =
    "END VERIFICATION REQUEST\n";
  
  public static final int CVS_JSERVER_PORT = 2402;
  protected static final String BEGIN_DSA_AUTH_REQUEST = "BEGIN DSA AUTH REQUEST\n";
  protected static final String END_DSA_AUTH_REQUEST = "END DSA AUTH REQUEST\n";
  protected static final String BEGIN_DSA_VERIFICATION_REQUEST =
    "BEGIN DSA VERIFICATION REQUEST\n";
  protected static final String END_DSA_VERIFICATION_REQUEST =
    "END DSA VERIFICATION REQUEST\n";
  
  protected static final String AUTH_ACK = "I LOVE YOU\n";
  protected static final String AUTH_NACK = "I HATE YOU\n";
  protected static final String AUTH_PARTIAL_ACK = "I MIGHT LOVE YOU\n";
  
  public static final int AUTHENTICATION_FAILED = 0;
  public static final int AUTHENTICATION_SUCCESSFUL = 1;
  
  public static final int VERIFICATION_FAILED = 0;
  public static final int VERIFICATION_SUCCESSFUL = 1;
  
  public CVSConnection() {
    m_inputBuffer = "";
  }
  
  public void attachToSocket(Socket socket) {
    m_socket = socket;
  }
  
  public Socket getSocket() {
    return m_socket;
  }

  public void connect() throws IOException {
    m_istream = new BufferedInputStream(m_socket.getInputStream(),
                                        STREAM_BUFFER_SIZE);
    m_ostream = m_socket.getOutputStream();
    
    m_connected = true;
  }

  public void close() throws IOException {
    if (m_istream != null) {
      m_istream.close();
	  m_istream = null;
	}
    if (m_ostream != null) {
	  m_ostream.close();
	  m_ostream = null;
	}
    if (m_socket != null) {
	  m_socket.close();
	  m_socket = null;
	}
    
    m_inputBuffer = "";
    
    m_connected = false;
  }
  
  public void writeString(String str) throws IOException {
    byte buf[] = new byte[500];
    
    if (m_connected == false)
      throw new IOException("write to unconnected CVSConnection");
    
    CVSDebug.connDebug("Writing string '" + str + "' to connection");
    
    buf = str.getBytes();
    
    m_ostream.write(buf, 0, str.length());
  }
  
  public void writeBytes(byte[] bytes) throws IOException {
    if (m_connected == false)
      throw new IOException("write to unconnected CVSConnection");
    
    m_ostream.write(bytes, 0, bytes.length);
  }

  public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
    if (m_connected == false)
      throw new IOException("write to unconnected CVSConnection");
    
    m_ostream.write(bytes, offset, length);
  }
  
  public void readBytes(byte[] bytes) throws IOException {
    readBytes(bytes, 0, bytes.length);
  }
  
  public void readBytes(byte[] bytes, int length) throws IOException {
    readBytes(bytes, 0, length);
  }
  
  public void readBytes(byte[] buf, int offset, int length) throws IOException {
    int i = offset;
    
    if (m_connected == false)
      throw new IOException("read from unconnected CVSConnection");
    
    do {
      if (m_inputBuffer.length() > 0) {
        buf[i] = readFromPushBackBuffer();
	    i++;
	  }
      else {
	    int num_read = m_istream.read(buf, i, length - i);
	    i += num_read; /* we're done. */
	  }
    } while (i < length);
  }

  public String readLine() throws IOException {
    byte buf[] = new byte[1000];
    int i = -1;
    
    if (m_connected == false)
      throw new IOException("read from unconnected CVSConnection");
    
    do {
      i++;
      if (m_inputBuffer.length() > 0)
        buf[i] = readFromPushBackBuffer();
      else
        buf[i] = (byte)m_istream.read();

      if (buf[i] == -1 && i == 0)
        return null;
    } while (buf[i] != '\n' && buf[i] != -1);
    
    CVSDebug.connDebug("Read '" + (new String(buf, 0, i+1)) + "' from connection");
    
    return new String(buf, 0, i + 1);
  }

  public void unreadString(String string) throws IOException {
    if (m_connected == false)
      throw new IOException("unread from unconnected CVSConnection");
    
    m_inputBuffer = string + m_inputBuffer;
  }

  private byte readFromPushBackBuffer() {
    byte foo[];
    
    foo = m_inputBuffer.getBytes();
    
    m_inputBuffer = m_inputBuffer.substring(1);
    
    return foo[0];
  }

  public int available() throws IOException {
    if (m_connected == false)
      throw new IOException("available() called on unconnected CVSConnection");
    
    return m_inputBuffer.length() + m_istream.available();
  }

  public boolean isConnected() {
    return m_connected;
  }

  private BufferedInputStream m_istream;
  private String m_inputBuffer; // a string push-back buffer.
  private OutputStream m_ostream;
  private Socket m_socket;
  
  private boolean m_connected;
}
