/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.util;

import com.hungry.javacvs.util.*;

import java.io.*;

public class CVSProcessSink
{
  public CVSProcessSink(Process process,
			CVSConnection conn)
    {
      m_process = process;

      m_processOutput = process.getErrorStream();

      m_conn = conn;
    }

  public void run()
    {
      try {
	int total_read = 0;

	while (m_processOutput.available() > 0)
	  {
	    byte buf[] = new byte[1024];
	    int num_read;

	    num_read = m_processOutput.read(buf);
	    total_read += num_read;

	    System.out.println("Read " + num_read + " bytes from the process");
	    if (num_read != -1)
	      m_conn.writeBytes(buf, 0, num_read);
	  }

	CVSDebug.debug("Read total of " + total_read + " bytes from process.");
      }
      catch (Exception e)
	{
	  System.out.println("Exception in CVSProcessSink.run():\n");
	  e.printStackTrace();
	}
    }

  public static CVSProcessSink create(String command_line,
				      CVSConnection client_conn)
    {
      try {
	return new CVSProcessSink(Runtime.getRuntime().exec(command_line),
				  client_conn);
      }
      catch (IOException e)
	{
	  return null;
	}
    }

  private Process m_process;
  private CVSConnection m_conn;

  private InputStream m_processOutput;
}
