/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.requests;

import com.hungry.javacvs.server.util.*;
import com.hungry.javacvs.util.*;

import java.net.*;
import java.io.*;

public class CVSModifiedRequest extends CVSRequestHandler {
  public void handleRequest() throws IOException {
    String filename = m_conn.readLine();
    String mode = m_conn.readLine();
    String filesize = m_conn.readLine();
    byte buf[];
    int int_filesize = Integer.parseInt(filesize.trim());
    CVSFileArg file_arg = new CVSFileArg();
    
    CVSDebug.debug("CVSModifiedRequest file = " + filename +
                   "\tmode = " + mode +
                   "\tsize = " + int_filesize);

    /* now we sink the contents of a file into a byte buffer. */
    buf = new byte[int_filesize];
    
    m_conn.readBytes(buf);
    
    file_arg.status = CVSFileArg.FILE_MODIFIED;
    file_arg.filename = filename;
    file_arg.mode = mode;
    file_arg.size = int_filesize;
    file_arg.contents = new String(buf);

    m_state.addArgument(file_arg);
  }
}
