/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server.requests;

import com.hungry.javacvs.server.util.*;
import com.hungry.javacvs.util.*;

import java.net.*;
import java.io.*;

public class CVSGlobalOptionRequest extends CVSRequestHandler {
  public void handleRequest() throws IOException {
    String line = m_conn.readLine();
    
    if (line.trim().equals("-t")) {
      m_state.enableTracing();
    }
    else if (line.trim().equals("-n")) {
      m_state.disableDiskAccess();
    }
    else if (line.trim().equals("-l")) {
      m_state.disableHistory();
    }
    else if (line.trim().equals("-q")) {
      m_state.beQuiet();
    }
    else if (line.trim().equals("-Q")) {
      m_state.beReallyQuiet();
    }
    
    CVSDebug.debug("global_option " + line);
  }
}
