/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.server;

import com.hungry.javacvs.server.requests.*;
import com.hungry.javacvs.server.util.*;
import com.hungry.javacvs.util.*;

public class CVSServer
{
  public CVSServer(int method, int min_threads, int max_threads)  {
    try {
      m_serverSocket = CVSServerSocket.createSocketForMethod(method);
      m_minThreads = min_threads;
      m_maxThreads = max_threads;
    }
    catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }

  private void dumpThreadState() {
    m_handlerThreadGroup.list();
  }

  private void startUp() {
    /* set up our initial pool of threads */
    m_handlerThreadGroup = new ThreadGroup("CVS Handlers");
    m_connectionQueue = new CVSConnectionQueue();

    for (int i = 0; i < m_minThreads; i ++) {
      CVSHandlerThread new_thread = new CVSHandlerThread(m_handlerThreadGroup,
                                                         m_connectionQueue);
      new_thread.start();
    }

    /* now we start the main loop, accepting connections from the
       server socket and pushing them onto the connectionQueue */
    while (true) {
      CVSServerConnection conn = m_serverSocket.accept();

      m_connectionQueue.add(conn);
    }
  }

  public static void main(String args[]) {
    String method_prop = System.getProperty("cvs.server.method", "pserver");
    String min_threads_prop = System.getProperty("cvs.server.min_threads", "5");
    String max_threads_prop = System.getProperty("cvs.server.max_threads", "20");
    int min_threads;
    int max_threads;
    int method;

    min_threads = Integer.valueOf(min_threads_prop).intValue();
    max_threads = Integer.valueOf(max_threads_prop).intValue();
    method = CVSRoot.stringToMethod(method_prop);

    CVSServer server = new CVSServer(method, min_threads, max_threads);

    CVSRequestHandler.setupHandlers();

    System.out.println
      ("Hungry JCVS Server - A plugable revision control system server\n" +
       "Copyright (C) 1997-1999 The Hungry Programmers.  All Rights Reserved");
    
    server.startUp();
  }

  private CVSConnectionQueue m_connectionQueue;
  private CVSServerSocket m_serverSocket;
  private ThreadGroup m_handlerThreadGroup;
  private int m_minThreads;
  private int m_maxThreads;
}
