/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * dealings with the ~/.cvspass file
 */

package com.hungry.javacvs.client.util;

import com.hungry.javacvs.util.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; /* for EventListenerList */

public class CVSPass
{
  /* notification generated when the client asks us for a password we
     don't have. The notification gets routed back through to the FE,
     which prompts the user for the password and then calls
     setPasswordForRepository before returning to us. If they hit
     cancel, it is assumed that the setPasswordForRepository function
     is not called, and getPasswordForRepository will return null. */

  public static final String promptUserForPassword = "Prompt User for Password";
  
  public CVSPass() {
    m_passwordDictionary = new Hashtable();
    
    CVSDebug.debug("Reading from file.");
    
    readFromFile();
    
    CVSDebug.debug("Dumping.");
    
    if (CVSDebug.isDebuggingOn()) {
      dumpStuff();
    }
  }

  public synchronized String getPasswordForRepository(String repository) {
    String password = (String)m_passwordDictionary.get(repository);
    
    if (password == null) {
      firePassEvent(new CVSPassQueryEvent(this, repository));
	  password = (String)m_passwordDictionary.get(repository);
	}
    
    return password;
  }

  public void firePassEvent(CVSPassQueryEvent e) 
    {
      // Guaranteed to return a non-null array
      Object[] listeners = listenerList.getListenerList();
      
      for (int i = listeners.length-2; i>=0; i-=2) {
        if (listeners[i] == CVSPassListener.class) {
          ((CVSPassListener)listeners[i+1]).passQuery(e);
        }
      }
    }

  /* managing listeners */
  public void addCVSPassListner(CVSPassListener l) 
    {
      listenerList.add(CVSPassListener.class, l);
    }

  public void removeCVSUIListener(CVSPassListener l) 
    {
      listenerList.remove(CVSPassListener.class, l);
    }
  
  private void dumpStuff() {
    Enumeration enum = m_passwordDictionary.keys();
    
    while (enum.hasMoreElements()) {
	  String repository = (String)enum.nextElement();
      
	  CVSDebug.debug("Repository from .cvspass is " + repository);
	}
  }

  public synchronized void setPasswordForRepository(String password,
                                                    String repository) {
    m_passwordDictionary.put(repository, password);
  }
  
  private void processLine(String line) {
    int i = line.indexOf(' ');
    String repository;
    String password;
    
    if (i == -1) i = line.indexOf('\t');
    
    if (i == -1) return; // XXX should probably be an error conditions.
    
    repository = line.substring(0, i).trim();

    // we do this instead of trimming the password since it can
    // have spaces at the end of it.
    while (Character.isWhitespace((char)line.charAt(i)))
      i++;
    
    password = line.substring(i);
    
    m_passwordDictionary.put(repository, password);
  }
  
  private synchronized void writeToFile() {
    File pass_file = new File(System.getProperty("user.home") +
                              File.separator +
                              cvspass_filename);
    if (!pass_file.exists() || pass_file.canWrite()) {
        try {
          PrintWriter writer = new PrintWriter (new FileOutputStream(pass_file));
          Enumeration enum = m_passwordDictionary.keys();
          
          while (enum.hasMoreElements()) {
            String repository = (String)enum.nextElement();
            
            writer.println(repository + " " + (String)m_passwordDictionary.get(repository));
	      }
          
          writer.close();
        }
        catch (Exception e) {
	      /* shouldn't get any exceptions here... */
	      /*XXX */
	    }
    }
  }
  
  private synchronized void readFromFile() {
    File pass_file = new File(System.getProperty("user.home") +
                              File.separator +
                              cvspass_filename);
    if (pass_file.exists() && pass_file.canRead()) {
	  try {
	    FileReader reader = new FileReader(pass_file);
	    LineNumberReader lreader = new LineNumberReader(reader);
	    String s;
        
	    while ((s = lreader.readLine()) != null)
	      processLine(s);
        
	  }
	  catch (Exception e) {
        if (CVSDebug.isDebuggingOn()) {
          CVSDebug.debug("error opening .cvspass file.");
          e.printStackTrace(new PrintWriter(CVSDebug.getDebugWriter()));
        }
      }
	}
    else
      CVSDebug.debug(pass_file.toString() + " doesn't exist");
  }
  
  public static final String cvspass_filename = ".cvspass";
  private Hashtable m_passwordDictionary;
  private EventListenerList listenerList = new EventListenerList();
}
