/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import java.io.*;

class CVSTreeNode
{
  class DirectoryFilter implements FilenameFilter
  {
    public boolean accept(File dir, String name)
      {
	File file;

	/* we don't want to show the CVS directories. */
	if (name.equals("CVS")) return false;

	file = new File(dir, name);

	return file.isDirectory();
      }
  }

  public CVSTreeNode(File dir)
    {
      m_dir = dir;

      m_subdirNames = m_dir.list(new DirectoryFilter());
      m_subdirNodes = new CVSTreeNode[m_subdirNames.length];
    }

  public int getChildCount()
    {
      return m_subdirNames.length;
    }

  public Object getChild(int index)
    {
      if (m_subdirNodes[index] == null)
	m_subdirNodes[index] = new CVSTreeNode(new File(m_dir,
							m_subdirNames[index]));

      return m_subdirNodes[index];
    }

  public int getIndexOfChild(Object child)
    {
      int i;

      for (i = 0; i < m_subdirNodes.length; i ++)
	if (child == m_subdirNodes[i])
	  return i;

      return -1;
    }

  public boolean isLeaf()
    {
      return m_subdirNames.length == 0;
    }

  public String toString()
    {
      return m_dir.getName();
    }

  public String getPath()
    {
      return m_dir.getPath();
    }

  public File getDir()
    {
      return m_dir;
    }

  private File m_dir;
  private CVSTreeNode m_subdirNodes[];
  private String m_subdirNames[];
}

