/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.ui.*;
import com.hungry.javacvs.client.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class CVSProjectEditorDialog extends JDialog
{
  class CVSProjectEditorView extends JComponent
  {
    public CVSProjectEditorView(CVSProject project)
      {
	GridLayout layout = new GridLayout();

	m_project = project;

	layout.setColumns(2);

	setLayout(layout);

	fillInFromProject();
      }

    public void addModuleAndTag(String module,
				String tag)
      {
      }

    private void fillInFromProject()
      {
	Enumeration modules = m_project.getModuleEnumeration();
	String module;

	while (modules.hasMoreElements() 
	       && (module = (String)modules.nextElement()) != null)
	  {
	    addModuleAndTag(module, m_project.tagForModule(module));
	  }
      }

    private CVSProject m_project;
  }

  private void initWithProject(CVSProject project)
    {
      m_view = new CVSProjectEditorView(project);
      
      getContentPane().setLayout(new BorderLayout());
      getContentPane().add(new JScrollPane(m_view));
    }

  public CVSProjectEditorDialog(JFrame owner, CVSProject project)
    {
      super(owner, "CVS Project Editor", true);

      initWithProject(project);
    }

  public CVSProjectEditorDialog(JFrame owner)
    {
      super(owner, "CVS Project Editor", true);

      initWithProject(new CVSProject("New Project"));
    }

  private CVSProjectEditorView m_view;
}
