/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.jfc;

import com.hungry.javacvs.client.ui.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

public class CVSMessageDialog extends JDialog
{
  class UIListener implements CVSUIListener
  {
    public void uiChanged(CVSUIEvent e)
      {
	if (e instanceof CVSUIMessageEvent)
	  {
	    CVSUIMessageEvent me = (CVSUIMessageEvent)e;

	    appendText(me.getMessage());
	  }
/*
	else if (e instanceof CVSUIBusyStateEvent)
	  {
	    CVSUIBusyStateEvent be = (CVSUIBusyStateEvent)e;

	    if (be.getBusyState() == false)
	      unhookListener();
	  }
*/
      }
  }

  public CVSMessageDialog(CVSView parent_view)
    {
      super(parent_view.getFrame(), "CVS Message");

      parent = parent_view;
      listener = new UIListener();
      parent.getUI().addCVSUIListener(listener);

      setSize(500, 400);

      text_area = new JTextArea(15, 80);
      text_area.setEditable(false);

      getContentPane().add(new JScrollPane(text_area));
    }

  private void appendText(String line)
    {
      text_area.append(line);
    }

  private void unhookListener()
    {
      parent.getUI().removeCVSUIListener(listener);
    }

  private UIListener listener;
  private CVSView parent;
  private JTextArea text_area;
}
