/* JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.ui.composer_plugin;

import com.hungry.javacvs.util.*;
import com.hungry.javacvs.client.*;
import com.hungry.javacvs.client.ui.*;
import com.hungry.javacvs.client.util.*;

import java.io.*;
import netscape.security.PrivilegeManager;
import netscape.plugin.composer.*;
import netscape.plugin.composer.io.*;

public class CVSUpdatePlugin extends CVSComposerPlugin
{

  public CVSUpdatePlugin()
	{
	  CVSDebug.debug("In CVSUpdatePlugin()");
	}

  public String getName()
	{
	  return "Update from Repository";
	}

  public String getCategory()
	{
	  return "Version Control";
	}

  public String getHint()
	{
	  return "Fetch changes made to this file by other users.";
	}

  public boolean perform(Document document) throws IOException
	{
	  try {
		enableTarget();
	  }
	  catch (Exception e)
		{
		  e.printStackTrace();
		  return false;
		}

	  m_ui = new CVSUI();

	  return true;
	}

  private CVSUI m_ui;
}
