/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1999 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.requests;

import com.hungry.javacvs.util.*;

import java.util.*;

public class CVSRequestQueue {
  
  public CVSRequestQueue() {
    m_queue = new Vector();
  }

  public synchronized void add(CVSRequest conn) {
    CVSDebug.debug("adding request to queue...");

    m_queue.addElement(conn);

    notify();
  }

  public synchronized CVSRequest get() {
    CVSRequest req = null;

    try {
      if (m_queue.size() == 0) {
        /* no available Requests */
        wait();
      }

      CVSDebug.debug("getting request from queue...");
      
      /* we were either notified, or there were Requests to begin with. */
      req = (CVSRequest)m_queue.firstElement();
      m_queue.removeElement(req);

      return req;
    }
    catch (Exception e) {
      return req;
    }
  }

  private Vector m_queue;
}
