/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.handlers;

import com.hungry.javacvs.client.util.*;
import com.hungry.javacvs.util.*;
import java.io.*;

/**
 * Handler for the Valid-requests response.
 */
public class CVSValidRequestsHandler extends CVSGenericHandler
{
  public void handleResponse() throws CVSError, IOException {
    String line;
    String request;
    int space_index;
    
    fireHandlerEvent(new CVSHandlerInvalidateReqsEvent(this));
    
    line = m_conn.readLine();
    
    space_index = line.indexOf(' ');
    
    while (space_index != -1) {
	  request = line.substring(0, space_index);
	  line = line.substring(space_index + 1);
      
	  fireHandlerEvent(new CVSHandlerEnableReqEvent(this, request));
      
	  space_index = line.indexOf(' ');
	}
  }
}
