/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.handlers;

import com.hungry.javacvs.client.util.*;
import com.hungry.javacvs.util.*;
import java.io.*;

/**
 * Handler for the Updated response.
 */
public class CVSUpdatedHandler extends CVSGenericHandler
{
  public CVSUpdatedHandler(CVSConnection conn) {
    super(conn);
  }
  
  public CVSUpdatedHandler() {
  }

  public void handleResponse() throws IOException, CVSError, CVSOperationComplete {
    String directory, filename, mode, new_file;
    CVSEntriesLine entries_line;
    FileOutputStream ostream;
    CVSEntriesLine entry;
    byte buf[] = new byte[1024];
    int file_size;
    
    try {
      directory = m_conn.readLine().trim();
      
      filename = m_conn.readLine().trim();
      
      entry = new CVSEntriesLine(m_conn.readLine().trim());
      
      fireHandlerEvent(new CVSHandlerAddEntryEvent(this, entry));
      
      new_file = ".#jcvs-" + entry.getName() + "." + entry.getVersion();
      
      ostream = new FileOutputStream(new_file);
      
      mode = m_conn.readLine();
      
      file_size = (new Integer(m_conn.readLine().trim())).intValue();
      
      while (file_size > 1024) {
	    m_conn.readBytes(buf);
	    
	    ostream.write(buf);
	    
	    file_size -= 1024;
	  }
      
      m_conn.readBytes(buf, 0, file_size);
      ostream.write(buf, 0, file_size);
      
      ostream.close();
      
      fireHandlerEvent(new CVSHandlerUpdateFileEvent(this, entry));
      
      /* do something really cool here. XXXX */
    }
    catch (CVSInvalidEntriesLine e) {
	  /* ummm... */
	  e.printStackTrace();
	}
  }
}
