/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * JavaCVS - The Hungry Java CVS Client/Server.
 * Copyright (C) 1997-1998 The Hungry Programmers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.hungry.javacvs.client.handlers;

import com.hungry.javacvs.client.util.*;
import com.hungry.javacvs.util.*;
import java.util.*;
import java.io.*;

import javax.swing.event.*; /* for EventListenerList */

public abstract class CVSResponseHandler
{
  public CVSResponseHandler() {
  }

  public CVSResponseHandler(CVSConnection conn) {
    setConnection(conn);
  }
  
  public void setConnection(CVSConnection conn) {
    m_conn = conn;
  }

  public void fireHandlerEvent(CVSHandlerEvent e) {
    // Guaranteed to return a non-null array
    Object[] listeners = listenerList.getListenerList();
    
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i] == CVSHandlerListener.class) {
        ((CVSHandlerListener)listeners[i+1]).handlerEvent(e);
      }
    }
  }

  /* managing listeners */
  public void addCVSHandlerListener(CVSHandlerListener l) {
    listenerList.add(CVSHandlerListener.class, l);
  }

  public void removeCVSHandlerListener(CVSHandlerListener l) {
    listenerList.remove(CVSHandlerListener.class, l);
  }

  public abstract void handleResponse()
    throws IOException, CVSError, CVSOperationComplete;

  public abstract boolean connectionShouldClose();

  /** our list of listeners. */
  protected EventListenerList listenerList = new EventListenerList();

  protected CVSConnection m_conn;

  public static void setupHandlers() {
    String pkg = "com.hungry.javacvs.client.handlers.";
    
    if (m_handlerDictionary != null) return;
    
    m_handlerDictionary = new Hashtable();
    
    try {
      m_handlerDictionary.put("Valid-requests",
                              Class.forName(pkg + "CVSValidRequestsHandler"));
      m_handlerDictionary.put("Checked-in",
                              Class.forName(pkg + "CVSCheckedInHandler"));
      m_handlerDictionary.put("New-entry",
                              Class.forName(pkg + "CVSNewEntryHandler"));
      m_handlerDictionary.put("Updated",
                              Class.forName(pkg + "CVSUpdatedHandler"));
      m_handlerDictionary.put("Merged",
                              Class.forName(pkg + "CVSMergedHandler"));
      m_handlerDictionary.put("Patched",
                              Class.forName(pkg + "CVSPatchedHandler"));
      m_handlerDictionary.put("Removed",
                              Class.forName(pkg + "CVSRemovedHandler"));
      m_handlerDictionary.put("Mode",
                              Class.forName(pkg + "CVSModeHandler"));
      m_handlerDictionary.put("Checksum",
                              Class.forName(pkg + "CVSChecksumHandler"));
      m_handlerDictionary.put("Copy-file",
                              Class.forName(pkg + "CVSCopyFileHandler"));
      m_handlerDictionary.put("Remove-entry",
                              Class.forName(pkg + "CVSRemoveEntryHandler"));
      m_handlerDictionary.put("Set-static-directory",
                              Class.forName(pkg + "CVSSetStaticDirHandler"));
      m_handlerDictionary.put("Clear-static-directory",
                              Class.forName(pkg + "CVSClearStaticDirHandler"));
      m_handlerDictionary.put("Set-sticky",
                              Class.forName(pkg + "CVSSetStickyHandler"));
      m_handlerDictionary.put("Template",
                              Class.forName(pkg + "CVSTemplateHandler"));
      m_handlerDictionary.put("Set-checkin-prog",
                              Class.forName(pkg + "CVSSetCheckinProgHandler"));
      m_handlerDictionary.put("Set-update-prog",
                              Class.forName(pkg + "CVSSetUpdateProgHandler"));
      m_handlerDictionary.put("Notified",
                              Class.forName(pkg + "CVSNotifiedHandler"));
      m_handlerDictionary.put("Module-expansion",
                              Class.forName(pkg + "CVSModuleExpansionHandler"));
      m_handlerDictionary.put("M",
                              Class.forName(pkg + "CVSMsgHandler"));
      m_handlerDictionary.put("E",
                              Class.forName(pkg + "CVSErrorHandler"));
      m_handlerDictionary.put("error",
                              Class.forName(pkg + "CVSErrorHandler"));
      m_handlerDictionary.put("ok",
                              Class.forName(pkg + "CVSOkHandler"));
    }
    catch (Exception e) {
	  System.err.println("Error while adding default handlers: " + e);
	  System.exit(2);
	}
  }

  public static Enumeration handlerNameEnumeration() {
    return m_handlerDictionary.keys();
  }

  public static CVSResponseHandler getHandlerInstanceByName(String name,
                                                            CVSConnection conn) {
    Class handler_class = (Class)m_handlerDictionary.get(name);
    CVSResponseHandler handler = null;
    
    try {
      handler = (CVSResponseHandler)( handler_class.newInstance() );
      handler.setConnection(conn);
    }
    catch (Exception e) {
      System.err.println("Some error when creating the handler instance named " +
                         name + ": " + e.toString());
    }
    
    return handler;
  }

  private static Hashtable m_handlerDictionary;
}
